/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.utils;

import com.phloc.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LevenshteinDistance {
    private static final LevenshteinDistance s_aInstance = new LevenshteinDistance();

    private LevenshteinDistance() {
    }

    private static int _getDistance111(@Nonnull char[] aStr1, @Nonnegative int nLen1, @Nonnull char[] aStr2, @Nonnegative int nLen2) {
        int i;
        int[] aPrevRow = new int[nLen1 + 1];
        int[] aCurRow = new int[nLen1 + 1];
        for (i = 0; i <= nLen1; ++i) {
            aPrevRow[i] = i;
        }
        for (int j = 0; j < nLen2; ++j) {
            char ch2 = aStr2[j];
            aCurRow[0] = j + 1;
            for (i = 0; i < nLen1; ++i) {
                int nSubstVal = aStr1[i] == ch2 ? 0 : 1;
                aCurRow[i + 1] = Math.min(Math.min(aCurRow[i] + 1, aPrevRow[i + 1] + 1), aPrevRow[i] + nSubstVal);
            }
            int[] tmp = aPrevRow;
            aPrevRow = aCurRow;
            aCurRow = tmp;
        }
        return aPrevRow[nLen1];
    }

    private static int _getDistance(@Nonnull char[] aStr1, @Nonnegative int nLen1, @Nonnull char[] aStr2, @Nonnegative int nLen2, @Nonnegative int nCostInsert, @Nonnegative int nCostDelete, @Nonnegative int nCostSubstitution) {
        int i;
        int[] aPrevRow = new int[nLen1 + 1];
        int[] aCurRow = new int[nLen1 + 1];
        for (i = 0; i <= nLen1; ++i) {
            aPrevRow[i] = i * nCostInsert;
        }
        for (int j = 0; j < nLen2; ++j) {
            char ch2 = aStr2[j];
            aCurRow[0] = (j + 1) * nCostDelete;
            for (i = 0; i < nLen1; ++i) {
                int nSubstCost = aStr1[i] == ch2 ? 0 : nCostSubstitution;
                aCurRow[i + 1] = Math.min(Math.min(aCurRow[i] + nCostInsert, aPrevRow[i + 1] + nCostDelete), aPrevRow[i] + nSubstCost);
            }
            int[] tmp = aPrevRow;
            aPrevRow = aCurRow;
            aCurRow = tmp;
        }
        return aPrevRow[nLen1];
    }

    public static int getDistance(@Nullable char[] aStr1, @Nullable char[] aStr2) {
        int nLen2;
        int nLen1 = aStr1 == null ? 0 : aStr1.length;
        int n = nLen2 = aStr2 == null ? 0 : aStr2.length;
        if (nLen1 == 0) {
            return nLen2;
        }
        if (nLen2 == 0) {
            return nLen1;
        }
        return LevenshteinDistance._getDistance111(aStr1, nLen1, aStr2, nLen2);
    }

    public static int getDistance(@Nullable char[] aStr1, @Nullable char[] aStr2, @Nonnegative int nCostInsert, @Nonnegative int nCostDelete, @Nonnegative int nCostSubstitution) {
        int nLen2;
        if (nCostInsert < 0) {
            throw new IllegalArgumentException("Insert cost is invalid: " + nCostInsert);
        }
        if (nCostDelete < 0) {
            throw new IllegalArgumentException("Deletion cost is invalid: " + nCostDelete);
        }
        if (nCostSubstitution < 0) {
            throw new IllegalArgumentException("Substitution cost is invalid: " + nCostSubstitution);
        }
        int nLen1 = aStr1 == null ? 0 : aStr1.length;
        int n = nLen2 = aStr2 == null ? 0 : aStr2.length;
        if (nLen1 == 0) {
            return nLen2 * nCostInsert;
        }
        if (nLen2 == 0) {
            return nLen1 * nCostInsert;
        }
        if (nCostInsert == 1 && nCostDelete == 1 && nCostSubstitution == 1) {
            return LevenshteinDistance._getDistance111(aStr1, nLen1, aStr2, nLen2);
        }
        return LevenshteinDistance._getDistance(aStr1, nLen1, aStr2, nLen2, nCostInsert, nCostDelete, nCostSubstitution);
    }

    public static int getDistance(@Nullable String sStr1, @Nullable String sStr2) {
        int nLen1 = StringHelper.getLength(sStr1);
        int nLen2 = StringHelper.getLength(sStr2);
        if (nLen1 == 0) {
            return nLen2;
        }
        if (nLen2 == 0) {
            return nLen1;
        }
        return LevenshteinDistance._getDistance111(sStr1.toCharArray(), nLen1, sStr2.toCharArray(), nLen2);
    }

    public static int getDistance(@Nullable String sStr1, @Nullable String sStr2, @Nonnegative int nCostInsert, @Nonnegative int nCostDelete, @Nonnegative int nCostSubstitution) {
        if (nCostInsert < 0) {
            throw new IllegalArgumentException("Insert cost is invalid: " + nCostInsert);
        }
        if (nCostDelete < 0) {
            throw new IllegalArgumentException("Deletion cost is invalid: " + nCostDelete);
        }
        if (nCostSubstitution < 0) {
            throw new IllegalArgumentException("Substitution cost is invalid: " + nCostSubstitution);
        }
        int nLen1 = StringHelper.getLength(sStr1);
        int nLen2 = StringHelper.getLength(sStr2);
        if (nLen1 == 0) {
            return nLen2 * nCostInsert;
        }
        if (nLen2 == 0) {
            return nLen1 * nCostInsert;
        }
        if (nCostInsert == 1 && nCostDelete == 1 && nCostSubstitution == 1) {
            return LevenshteinDistance._getDistance111(sStr1.toCharArray(), nLen1, sStr2.toCharArray(), nLen2);
        }
        return LevenshteinDistance._getDistance(sStr1.toCharArray(), nLen1, sStr2.toCharArray(), nLen2, nCostInsert, nCostDelete, nCostSubstitution);
    }
}

