/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.encode.IDecoder;
import com.phloc.commons.encode.IEncoder;
import com.phloc.commons.encode.IdentityDecoder;
import com.phloc.commons.encode.IdentityEncoder;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.microdom.reader.XMLMapHandler;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.url.IURLData;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.URLData;
import com.phloc.commons.url.URLProtocolRegistry;
import com.phloc.commons.url.encode.URLParameterEncoder;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class URLUtils {
    public static final String CHARSET_URL = "UTF-8";
    public static final Charset CHARSET_URL_OBJ = CCharset.CHARSET_UTF_8_OBJ;
    public static final char QUESTIONMARK = '?';
    public static final char AMPERSAND = '&';
    public static final char EQUALS = '=';
    public static final char HASH = '#';
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLUtils.class);
    private static final String QUESTIONMARK_STR = Character.toString('?');
    private static final char[] CLEANURL_OLD;
    private static final char[][] CLEANURL_NEW;

    private URLUtils() {
    }

    @Nonnull
    public static String urlDecode(@Nonnull String sValue) {
        return URLUtils.urlDecode(sValue, CHARSET_URL);
    }

    @Nonnull
    public static String urlDecode(@Nonnull String sValue, @Nonnull Charset aCharset) {
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        return URLUtils.urlDecode(sValue, aCharset.name());
    }

    @Nonnull
    public static String urlDecode(@Nonnull String sValue, @Nonnull @Nonempty String sCharset) {
        try {
            return URLDecoder.decode(sValue, sCharset);
        }
        catch (UnsupportedEncodingException ex) {
            return URLDecoder.decode(sValue);
        }
    }

    @Nonnull
    public static String urlEncode(@Nonnull String sValue) {
        return URLUtils.urlEncode(sValue, CHARSET_URL);
    }

    @Nonnull
    public static String urlEncode(@Nonnull String sValue, @Nonnull Charset aCharset) {
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        return URLUtils.urlEncode(sValue, aCharset.name());
    }

    @Nonnull
    public static String urlEncode(@Nonnull String sValue, @Nonnull @Nonempty String sCharset) {
        try {
            return URLEncoder.encode(sValue, sCharset);
        }
        catch (UnsupportedEncodingException ex) {
            return URLEncoder.encode(sValue);
        }
    }

    @Nullable
    public static String getCleanURLPartWithoutUmlauts(@Nullable String sURLPart) {
        return new String(StringHelper.replaceMultiple(sURLPart, CLEANURL_OLD, CLEANURL_NEW));
    }

    @Nonnull
    public static IURLData getAsURLData(@Nonnull String sHref) {
        return URLUtils.getAsURLData(sHref, IdentityDecoder.<String>create());
    }

    @Nonnull
    public static IURLData getAsURLData(@Nonnull String sHref, @Nonnull IDecoder<String> aParameterDecoder) {
        String sPath;
        String sAnchor;
        if (sHref == null) {
            throw new NullPointerException("href");
        }
        if (aParameterDecoder == null) {
            throw new NullPointerException("parameterDecoder");
        }
        IURLProtocol eProtocol = URLProtocolRegistry.getProtocol(sHref);
        if (eProtocol != null && !eProtocol.allowsForQueryParameters()) {
            return new URLData(sHref, null, null);
        }
        if (GlobalDebug.isDebugMode() && eProtocol != null) {
            try {
                new URL(sHref);
            }
            catch (MalformedURLException ex) {
                s_aLogger.warn("java.net.URL claims URL '" + sHref + "' to be invalid: " + ex.getMessage());
            }
        }
        LinkedHashMap<String, String> aParams = null;
        String sRemainingHref = sHref;
        int nIndexAnchor = sRemainingHref.indexOf(35);
        if (nIndexAnchor >= 0) {
            sAnchor = sRemainingHref.substring(nIndexAnchor + 1);
            sRemainingHref = sRemainingHref.substring(0, nIndexAnchor);
        } else {
            sAnchor = null;
        }
        int nQuestionIndex = sRemainingHref.indexOf(63);
        if (nQuestionIndex >= 0) {
            String sQueryString = sRemainingHref.substring(nQuestionIndex + 1);
            if (StringHelper.hasText(sQueryString)) {
                for (String sKeyValuePair : StringHelper.getExploded('&', sQueryString)) {
                    String sValue;
                    if (sKeyValuePair.length() <= 0) continue;
                    List<String> aParts = StringHelper.getExploded('=', sKeyValuePair, 2);
                    String sKey = aParts.get(0);
                    String string = sValue = aParts.size() == 2 ? aParts.get(1) : "";
                    if (StringHelper.hasNoText(sKey)) {
                        throw new IllegalArgumentException("key may not be empty!");
                    }
                    if (sValue == null) {
                        throw new NullPointerException("value may not be null");
                    }
                    if (aParams == null) {
                        aParams = new LinkedHashMap<String, String>();
                    }
                    aParams.put(aParameterDecoder.decode(sKey), aParameterDecoder.decode(sValue));
                }
            }
            sPath = sRemainingHref.substring(0, nQuestionIndex);
        } else {
            sPath = sRemainingHref;
        }
        return new URLData(sPath, aParams, sAnchor);
    }

    @Nonnull
    public static String getURLString(@Nonnull IURLData aURL, @Nullable String sParameterCharset) {
        return URLUtils.getURLString(aURL.getPath(), aURL.getAllParams(), aURL.getAnchor(), sParameterCharset);
    }

    @Nonnull
    public static String getURLString(@Nonnull IURLData aURL, @Nullable Charset aParameterCharset) {
        return URLUtils.getURLString(aURL.getPath(), aURL.getAllParams(), aURL.getAnchor(), aParameterCharset);
    }

    @Nullable
    public static String getURLString(@Nullable String sPath, @Nullable Map<String, String> aParams, @Nullable String sAnchor, @Nonnull IEncoder<String> aParameterEncoder) {
        if (sPath != null) {
            if (sPath.indexOf(63) >= 0) {
                throw new IllegalArgumentException("Path contains a '?': " + sPath);
            }
            if (sPath.indexOf(35) >= 0) {
                throw new IllegalArgumentException("Path contains a '#': " + sPath);
            }
        }
        if (aParameterEncoder == null) {
            throw new NullPointerException("parameterEncoder");
        }
        boolean bHasParams = aParams != null && !aParams.isEmpty();
        boolean bHasAnchor = StringHelper.hasText(sAnchor);
        if (!bHasParams && !bHasAnchor) {
            return sPath;
        }
        StringBuilder aSB = new StringBuilder(sPath);
        if (bHasParams) {
            if (aSB.indexOf(QUESTIONMARK_STR) >= 0) {
                char cLast = StringHelper.getLastChar(aSB);
                if (cLast != '?' && cLast != '&') {
                    aSB.append('&');
                }
            } else {
                aSB.append('?');
            }
            for (Map.Entry<String, String> aEntry : aParams.entrySet()) {
                String sKey = aEntry.getKey();
                String sValue = aEntry.getValue();
                aSB.append(aParameterEncoder.encode(sKey));
                if (StringHelper.hasText(sValue)) {
                    aSB.append('=').append(aParameterEncoder.encode(sValue));
                }
                aSB.append('&');
            }
            aSB.deleteCharAt(aSB.length() - 1);
        }
        if (bHasAnchor) {
            aSB.append('#').append(sAnchor);
        }
        return aSB.toString();
    }

    @Nullable
    public static String getURLString(@Nullable String sPath, @Nullable Map<String, String> aParams, @Nullable String sAnchor, @Nullable String sParameterCharset) {
        IEncoder aParameterEncoder = StringHelper.hasNoText(sParameterCharset) ? IdentityEncoder.create() : new URLParameterEncoder(CharsetManager.getCharsetFromName(sParameterCharset));
        return URLUtils.getURLString(sPath, aParams, sAnchor, aParameterEncoder);
    }

    @Nullable
    public static String getURLString(@Nullable String sPath, @Nullable Map<String, String> aParams, @Nullable String sAnchor, @Nullable Charset aParameterCharset) {
        IEncoder aParameterEncoder = aParameterCharset == null ? IdentityEncoder.create() : new URLParameterEncoder(aParameterCharset);
        return URLUtils.getURLString(sPath, aParams, sAnchor, aParameterEncoder);
    }

    @Nullable
    public static URL getAsURL(@Nullable String sURL) {
        if (StringHelper.hasText(sURL)) {
            try {
                return new URL(sURL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URL getAsURL(@Nullable URI aURI) {
        if (aURI != null) {
            try {
                return aURI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URI getAsURI(@Nullable String sURI) {
        if (StringHelper.hasText(sURI)) {
            try {
                return new URI(sURI);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        HashMap<String, String> aCleanURLMap = new HashMap<String, String>();
        XMLMapHandler.readMap(new ClassPathResource("codelists/cleanurl-data.xml"), aCleanURLMap);
        CLEANURL_OLD = new char[aCleanURLMap.size()];
        CLEANURL_NEW = new char[aCleanURLMap.size()][];
        int i = 0;
        for (Map.Entry aEntry : aCleanURLMap.entrySet()) {
            String sKey = (String)aEntry.getKey();
            if (sKey.length() != 1) {
                throw new IllegalStateException("Clean URL source character has an invalid length: " + sKey.length());
            }
            URLUtils.CLEANURL_OLD[i] = sKey.charAt(0);
            URLUtils.CLEANURL_NEW[i] = ((String)aEntry.getValue()).toCharArray();
            ++i;
        }
    }
}

