/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.sax;

import com.phloc.commons.annotations.CodingStyleguideUnaware;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.log.LogUtils;
import com.phloc.commons.xml.sax.AbstractSAXErrorHandler;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

@Immutable
@CodingStyleguideUnaware(value="logger too visible by purpose")
public class LoggingSAXErrorHandler
extends AbstractSAXErrorHandler {
    protected static final Logger s_aLogger = LoggerFactory.getLogger(LoggingSAXErrorHandler.class);
    private static final LoggingSAXErrorHandler s_aInstance = new LoggingSAXErrorHandler();

    public LoggingSAXErrorHandler() {
    }

    public LoggingSAXErrorHandler(@Nullable ErrorHandler aWrappedErrorHandler) {
        super(aWrappedErrorHandler);
    }

    @Nonnull
    public static LoggingSAXErrorHandler getInstance() {
        return s_aInstance;
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getErrorMessage(@Nonnull EErrorLevel eErrorLevel, SAXParseException aException) {
        return "SAX " + LoggingSAXErrorHandler.getSaxParseError(eErrorLevel, aException).getAsString(Locale.US);
    }

    @Override
    protected void internalLog(@Nonnull EErrorLevel eErrorLevel, SAXParseException aException) {
        LogUtils.log(s_aLogger, eErrorLevel, this.getErrorMessage(eErrorLevel, aException));
    }
}

