/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpressionTermOptimizer;
import com.phloc.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSExpressionMemberTermSimple
implements ICSSExpressionMember {
    private String m_sValue;
    private String m_sOptimizedValue;

    public CSSExpressionMemberTermSimple(int nValue) {
        this(Integer.toString(nValue));
    }

    public CSSExpressionMemberTermSimple(long nValue) {
        this(Long.toString(nValue));
    }

    public CSSExpressionMemberTermSimple(float fValue) {
        this(Float.toString(fValue));
    }

    public CSSExpressionMemberTermSimple(double dValue) {
        this(Double.toString(dValue));
    }

    public CSSExpressionMemberTermSimple(@Nonnull @Nonempty String sValue) {
        this.setValue(sValue);
    }

    public void setValue(@Nonnull @Nonempty String sValue) {
        if (StringHelper.hasNoText((CharSequence)sValue)) {
            throw new IllegalArgumentException("Empty value is not allowed");
        }
        this.m_sValue = sValue;
        this.m_sOptimizedValue = CSSExpressionTermOptimizer.getOptimizedValue(sValue);
    }

    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    @Nonempty
    public String getOptimizedValue() {
        return this.m_sOptimizedValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return aSettings.isOptimizedOutput() ? this.m_sOptimizedValue : this.m_sValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSExpressionMemberTermSimple)) {
            return false;
        }
        CSSExpressionMemberTermSimple rhs = (CSSExpressionMemberTermSimple)o;
        return this.m_sOptimizedValue.equals(rhs.m_sOptimizedValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sOptimizedValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("value", (Object)this.m_sValue).toString();
    }
}

