/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSRGB
implements ICSSWriteable {
    private String m_sRed;
    private String m_sGreen;
    private String m_sBlue;

    public CSSRGB(int nRed, int nGreen, int nBlue) {
        this(Integer.toString(CSSColorHelper.getRGBValue(nRed)), Integer.toString(CSSColorHelper.getRGBValue(nGreen)), Integer.toString(CSSColorHelper.getRGBValue(nBlue)));
    }

    public CSSRGB(@Nonnull @Nonempty String sRed, @Nonnull @Nonempty String sGreen, @Nonnull @Nonempty String sBlue) {
        this.setRed(sRed);
        this.setGreen(sGreen);
        this.setBlue(sBlue);
    }

    @Nonnull
    @Nonempty
    public String getRed() {
        return this.m_sRed;
    }

    public void setRed(@Nonnull @Nonempty String sRed) {
        if (StringHelper.hasNoText((CharSequence)sRed)) {
            throw new IllegalArgumentException("red");
        }
        this.m_sRed = sRed;
    }

    @Nonnull
    @Nonempty
    public String getGreen() {
        return this.m_sGreen;
    }

    public void setGreen(@Nonnull @Nonempty String sGreen) {
        if (StringHelper.hasNoText((CharSequence)sGreen)) {
            throw new IllegalArgumentException("green");
        }
        this.m_sGreen = sGreen;
    }

    @Nonnull
    @Nonempty
    public String getBlue() {
        return this.m_sBlue;
    }

    public void setBlue(@Nonnull @Nonempty String sBlue) {
        if (StringHelper.hasNoText((CharSequence)sBlue)) {
            throw new IllegalArgumentException("blue");
        }
        this.m_sBlue = sBlue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return "rgb(" + this.m_sRed + ',' + this.m_sGreen + ',' + this.m_sBlue + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSRGB)) {
            return false;
        }
        CSSRGB rhs = (CSSRGB)o;
        return this.m_sRed.equals(rhs.m_sRed) && this.m_sGreen.equals(rhs.m_sGreen) && this.m_sBlue.equals(rhs.m_sBlue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sRed).append((Object)this.m_sGreen).append((Object)this.m_sBlue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("red", (Object)this.m_sRed).append("green", (Object)this.m_sGreen).append("blue", (Object)this.m_sBlue).toString();
    }
}

