/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl.visit;

import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.CSSExpressionMemberTermURI;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.ICSSExpressionMember;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.decl.visit.DefaultCSSVisitor;
import com.phloc.css.decl.visit.ICSSUrlVisitor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSVisitorForUrl
extends DefaultCSSVisitor {
    private final ICSSUrlVisitor m_aVisitor;
    private ICSSTopLevelRule m_aTopLevelRule;

    public CSSVisitorForUrl(@Nonnull ICSSUrlVisitor aVisitor) {
        if (aVisitor == null) {
            throw new NullPointerException("visitor");
        }
        this.m_aVisitor = aVisitor;
    }

    @Override
    public void begin() {
        this.m_aVisitor.begin();
    }

    @Override
    public void onImport(@Nonnull CSSImportRule aImportRule) {
        this.m_aVisitor.onImport(aImportRule);
    }

    @Override
    public void onDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        CSSExpression aExpr = aDeclaration.getExpression();
        for (ICSSExpressionMember aMember : aExpr.getAllMembers()) {
            if (!(aMember instanceof CSSExpressionMemberTermURI)) continue;
            CSSExpressionMemberTermURI aExprTerm = (CSSExpressionMemberTermURI)aMember;
            this.m_aVisitor.onUrlDeclaration(this.m_aTopLevelRule, aDeclaration, aExprTerm);
        }
    }

    @Override
    public void onBeginStyleRule(@Nonnull CSSStyleRule aStyleRule) {
        this.m_aTopLevelRule = aStyleRule;
    }

    @Override
    public void onEndStyleRule(@Nonnull CSSStyleRule aStyleRule) {
        this.m_aTopLevelRule = null;
    }

    @Override
    public void onBeginPageRule(@Nonnull CSSPageRule aPageRule) {
        this.m_aTopLevelRule = aPageRule;
    }

    @Override
    public void onEndPageRule(@Nonnull CSSPageRule aPageRule) {
        this.m_aTopLevelRule = null;
    }

    @Override
    public void onBeginFontFaceRule(@Nonnull CSSFontFaceRule aFontFaceRule) {
        this.m_aTopLevelRule = aFontFaceRule;
    }

    @Override
    public void onEndFontFaceRule(@Nonnull CSSFontFaceRule aFontFaceRule) {
        this.m_aTopLevelRule = null;
    }

    @Override
    public void onBeginMediaRule(@Nonnull CSSMediaRule aMediaRule) {
        this.m_aTopLevelRule = aMediaRule;
    }

    @Override
    public void onEndMediaRule(@Nonnull CSSMediaRule aMediaRule) {
        this.m_aTopLevelRule = null;
    }

    @Override
    public void onBeginKeyframesRule(@Nonnull CSSKeyframesRule aKeyframesRule) {
        this.m_aTopLevelRule = aKeyframesRule;
    }

    @Override
    public void onEndKeyframesRule(@Nonnull CSSKeyframesRule aKeyframesRule) {
        this.m_aTopLevelRule = null;
    }

    @Override
    public void end() {
        this.m_aVisitor.end();
    }
}

