/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.EncoderException;
import com.phloc.commons.codec.ICodec;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlateCodec
implements ICodec {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FlateCodec.class);

    private static boolean _isZlibHead(byte[] buf) {
        if (buf.length >= 2) {
            int b0 = buf[0] & 0xFF;
            int b1 = buf[1] & 0xFF;
            if ((b0 & 0xF) == 8 && (b0 >> 4) + 8 <= 15 && ((b0 << 8) + b1) % 31 == 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] aEncodedBuffer) {
        if (aEncodedBuffer == null) {
            return null;
        }
        if (!FlateCodec._isZlibHead(aEncodedBuffer)) {
            s_aLogger.warn("ZLib header not found");
        }
        InflaterInputStream aDecodeIS = new InflaterInputStream(new NonBlockingByteArrayInputStream(aEncodedBuffer));
        NonBlockingByteArrayOutputStream aBAOS = new NonBlockingByteArrayOutputStream();
        try {
            if (StreamUtils.copyInputStreamToOutputStream(aDecodeIS, aBAOS).isFailure()) {
                throw new DecoderException("Failed to flate decode!");
            }
            byte[] byArray = aBAOS.toByteArray();
            return byArray;
        }
        finally {
            StreamUtils.close(aBAOS);
        }
    }

    @Override
    @Nullable
    public byte[] encode(@Nullable byte[] aBuffer) {
        if (aBuffer == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream aBAOS = new NonBlockingByteArrayOutputStream();
        DeflaterOutputStream aEncodeOS = new DeflaterOutputStream(aBAOS);
        if (StreamUtils.copyInputStreamToOutputStreamAndCloseOS(new NonBlockingByteArrayInputStream(aBuffer), aEncodeOS).isFailure()) {
            throw new EncoderException("Failed to flate encode!");
        }
        return aBAOS.toByteArray();
    }
}

