/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.compare;

import com.phloc.commons.compare.ESortOrder;
import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractComparator<DATATYPE>
implements Comparator<DATATYPE>,
Serializable {
    private ESortOrder m_eSortOrder;
    private Comparator<? super DATATYPE> m_aNestedComparator;

    public AbstractComparator() {
        this(ESortOrder.DEFAULT, null);
    }

    public AbstractComparator(@Nonnull ESortOrder eSortOrder) {
        this(eSortOrder, null);
    }

    public AbstractComparator(@Nullable Comparator<? super DATATYPE> aNestedComparator) {
        this(ESortOrder.DEFAULT, aNestedComparator);
    }

    public AbstractComparator(@Nonnull ESortOrder eSortOrder, @Nullable Comparator<? super DATATYPE> aNestedComparator) {
        if (eSortOrder == null) {
            throw new NullPointerException("sortOrder");
        }
        this.m_eSortOrder = eSortOrder;
        this.m_aNestedComparator = aNestedComparator;
    }

    @Nonnull
    public final AbstractComparator<DATATYPE> setSortOrder(@Nonnull ESortOrder eSortOrder) {
        if (eSortOrder == null) {
            throw new NullPointerException("sortOrder");
        }
        this.m_eSortOrder = eSortOrder;
        return this;
    }

    @Nonnull
    public final ESortOrder getSortOrder() {
        return this.m_eSortOrder;
    }

    protected abstract int mainCompare(DATATYPE var1, DATATYPE var2);

    @Override
    public final int compare(DATATYPE aElement1, DATATYPE aElement2) {
        int nCompare = this.mainCompare(aElement1, aElement2);
        if (nCompare == 0 && this.m_aNestedComparator != null) {
            nCompare = this.m_aNestedComparator.compare(aElement1, aElement2);
        }
        return (this.m_eSortOrder.isAscending() ? 1 : -1) * nCompare;
    }
}

