/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.filter.collections;

import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.string.ToStringGenerator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public final class FilterIterator<ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final Iterator<? extends ELEMENTTYPE> m_aBaseIter;
    @SuppressFBWarnings(value={"UWF_NULL_FIELD"})
    private ELEMENTTYPE m_aCurrent;
    private final IFilter<ELEMENTTYPE> m_aFilter;

    public FilterIterator(@Nonnull IIterableIterator<? extends ELEMENTTYPE> aBaseIter, @Nonnull IFilter<ELEMENTTYPE> aFilter) {
        this(aBaseIter.iterator(), aFilter);
    }

    public FilterIterator(@Nonnull Iterator<? extends ELEMENTTYPE> aBaseIter, @Nonnull IFilter<ELEMENTTYPE> aFilter) {
        if (aBaseIter == null) {
            throw new NullPointerException("baseIterator");
        }
        if (aFilter == null) {
            throw new NullPointerException("filter");
        }
        this.m_aBaseIter = aBaseIter;
        this.m_aFilter = aFilter;
        this._gotoNextCurrent();
    }

    public FilterIterator(@Nonnull Iterable<? extends ELEMENTTYPE> aBaseCont, @Nonnull IFilter<ELEMENTTYPE> aFilter) {
        if (aBaseCont == null) {
            throw new NullPointerException("baseContainer");
        }
        if (aFilter == null) {
            throw new NullPointerException("filter");
        }
        this.m_aBaseIter = aBaseCont.iterator();
        this.m_aFilter = aFilter;
        this._gotoNextCurrent();
    }

    private void _gotoNextCurrent() {
        this.m_aCurrent = null;
        while (this.m_aBaseIter.hasNext()) {
            ELEMENTTYPE aTmp = this.m_aBaseIter.next();
            if (!this.m_aFilter.matchesFilter(aTmp)) continue;
            this.m_aCurrent = aTmp;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_aCurrent != null;
    }

    @Override
    public ELEMENTTYPE next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE aRet = this.m_aCurrent;
        this._gotoNextCurrent();
        return aRet;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this;
    }

    public String toString() {
        return new ToStringGenerator(this).append("baseIter", this.m_aBaseIter).append("filter", this.m_aFilter).toString();
    }
}

