/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streamprovider;

import com.phloc.commons.io.IInputStreamAndReaderProvider;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.ToStringGenerator;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class ByteBufferInputStreamProvider
implements IInputStreamAndReaderProvider {
    private final ByteBuffer m_aBuffer;

    public ByteBufferInputStreamProvider(@Nonnull ByteBuffer aBuffer) {
        if (aBuffer == null) {
            throw new NullPointerException("buffer");
        }
        this.m_aBuffer = aBuffer;
    }

    @Nonnull
    public ByteBuffer getByteBuffer() {
        return this.m_aBuffer;
    }

    @Override
    @Nonnull
    public final NonBlockingByteArrayInputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.m_aBuffer.array());
    }

    @Override
    @Nonnull
    public final InputStreamReader getReader(@Nonnull String sCharset) {
        return StreamUtils.createReader((InputStream)this.getInputStream(), sCharset);
    }

    @Override
    @Nonnull
    public final InputStreamReader getReader(@Nonnull Charset aCharset) {
        return StreamUtils.createReader((InputStream)this.getInputStream(), aCharset);
    }

    public String toString() {
        return new ToStringGenerator(null).append("buffer", this.m_aBuffer).toString();
    }
}

