/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.io.streams.WrappedInputStream;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CountingInputStream
extends WrappedInputStream {
    private long m_nBytesRead = 0L;
    private long m_nPosition = 0L;
    private long m_nMark = 0L;

    public CountingInputStream(@Nonnull InputStream aSourceIS) {
        super(aSourceIS);
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        if (ret != -1) {
            ++this.m_nBytesRead;
            ++this.m_nPosition;
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int nOffset, int nLength) throws IOException {
        int ret = super.read(b, nOffset, nLength);
        if (ret != -1) {
            this.m_nBytesRead += (long)ret;
            this.m_nPosition += (long)ret;
        }
        return ret;
    }

    @Override
    public long skip(@Nonnegative long n) throws IOException {
        long nSkipped = super.skip(n);
        if (nSkipped > 0L) {
            this.m_nPosition += nSkipped;
        }
        return nSkipped;
    }

    @Override
    public synchronized void mark(@Nonnegative int nReadlimit) {
        super.mark(nReadlimit);
        this.m_nMark = this.m_nPosition;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.m_nPosition = this.m_nMark;
    }

    @Nonnegative
    public long getBytesRead() {
        return this.m_nBytesRead;
    }

    @Nonnegative
    public long getPosition() {
        return this.m_nPosition;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("bytesRead", this.m_nBytesRead).append("position", this.m_nPosition).toString();
    }
}

