/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.locale;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LocaleFormatter {
    private static final LocaleFormatter s_aInstance = new LocaleFormatter();

    private LocaleFormatter() {
    }

    @Nonnull
    public static String getFormatted(double dValue, @Nonnull Locale aDisplayLocale) {
        return NumberFormat.getNumberInstance(aDisplayLocale).format(dValue);
    }

    @Nonnull
    public static String getFormatted(int nValue, @Nonnull Locale aDisplayLocale) {
        return NumberFormat.getIntegerInstance(aDisplayLocale).format(nValue);
    }

    @Nonnull
    public static String getFormatted(long nValue, @Nonnull Locale aDisplayLocale) {
        return NumberFormat.getIntegerInstance(aDisplayLocale).format(nValue);
    }

    @Nonnull
    public static String getFormattedPercent(double dValue, @Nonnull Locale aDisplayLocale) {
        return NumberFormat.getPercentInstance(aDisplayLocale).format(dValue);
    }

    @Nonnull
    public static String getFormattedPercent(double dValue, @Nonnegative int nFractionDigits, @Nonnull Locale aDisplayLocale) {
        NumberFormat aNF = NumberFormat.getPercentInstance(aDisplayLocale);
        aNF.setMinimumFractionDigits(nFractionDigits);
        aNF.setMaximumFractionDigits(nFractionDigits);
        return aNF.format(dValue);
    }

    @Nullable
    public static Number parse(String sStr, @Nonnull Locale aParseLocale) {
        return LocaleFormatter.parse(sStr, NumberFormat.getInstance(aParseLocale));
    }

    @Nullable
    public static Number parse(@Nullable String sStr, @Nonnull NumberFormat aNF) {
        if (aNF == null) {
            throw new NullPointerException("numberFormat");
        }
        if (sStr != null) {
            try {
                return aNF.parse(sStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static double parseDouble(@Nullable String sStr, @Nonnull Locale aParseLocale, double dDefault) {
        return LocaleFormatter.parseDouble(sStr, NumberFormat.getInstance(aParseLocale), dDefault);
    }

    public static double parseDouble(@Nullable String sStr, @Nonnull NumberFormat aNF, double dDefault) {
        Number aNum = LocaleFormatter.parse(sStr, aNF);
        return aNum == null ? dDefault : aNum.doubleValue();
    }

    public static int parseInt(@Nullable String sStr, @Nonnull Locale aParseLocale, int nDefault) {
        return LocaleFormatter.parseInt(sStr, NumberFormat.getIntegerInstance(aParseLocale), nDefault);
    }

    public static int parseInt(@Nullable String sStr, @Nonnull NumberFormat aNF, int nDefault) {
        Number aNum = LocaleFormatter.parse(sStr, aNF);
        return aNum == null ? nDefault : aNum.intValue();
    }

    public static long parseLong(@Nullable String sStr, @Nonnull Locale aParseLocale, long nDefault) {
        return LocaleFormatter.parseLong(sStr, NumberFormat.getIntegerInstance(aParseLocale), nDefault);
    }

    public static long parseLong(@Nullable String sStr, @Nonnull NumberFormat aNF, long nDefault) {
        Number aNum = LocaleFormatter.parse(sStr, aNF);
        return aNum == null ? nDefault : aNum.longValue();
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String sStr, @Nonnull DecimalFormat aNF) {
        if (aNF == null) {
            throw new NullPointerException("numberFormat");
        }
        aNF.setParseBigDecimal(true);
        return (BigDecimal)LocaleFormatter.parse(sStr, aNF);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String sStr, @Nonnull Locale aParseLocale, @Nullable BigDecimal aDefault) {
        return LocaleFormatter.parseBigDecimal(sStr, NumberFormat.getIntegerInstance(aParseLocale), aDefault);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String sStr, @Nonnull NumberFormat aNF, @Nullable BigDecimal aDefault) {
        BigDecimal ret = null;
        if (aNF instanceof DecimalFormat) {
            ret = LocaleFormatter.parseBigDecimal(sStr, (DecimalFormat)aNF);
        } else {
            Number aNum = LocaleFormatter.parse(sStr, aNF);
            if (aNum != null) {
                ret = BigDecimal.valueOf(aNum.doubleValue());
            }
        }
        return ret == null ? aDefault : ret;
    }
}

