/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.math;

import com.phloc.commons.lang.DecimalFormatSymbolsFactory;
import com.phloc.commons.string.StringHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RoundHelper {
    private static final RoundHelper s_aInstance = new RoundHelper();

    private RoundHelper() {
    }

    public static double getRounded(double dValue, @Nonnegative int nScale, @Nonnull RoundingMode eMode, @Nonnull EDecimalType eType) {
        if (nScale < 0) {
            throw new IllegalArgumentException("Scale is too small: " + nScale);
        }
        if (eMode == null) {
            throw new NullPointerException("roundingMode");
        }
        if (eType == null) {
            throw new NullPointerException("type");
        }
        if (Double.isNaN(dValue) || Double.isInfinite(dValue)) {
            return dValue;
        }
        BigDecimal bd = BigDecimal.valueOf(dValue);
        if (eType.isExponential()) {
            BigDecimal bc = new BigDecimal(bd.unscaledValue(), bd.precision() - 1);
            return bc.setScale(nScale, eMode).scaleByPowerOfTen(bc.scale() - bd.scale()).doubleValue();
        }
        return bd.setScale(nScale, eMode).doubleValue();
    }

    public static double getRoundedUpFix(double dValue, @Nonnegative int nScale) {
        return RoundHelper.getRounded(dValue, nScale, RoundingMode.HALF_UP, EDecimalType.FIX);
    }

    public static double getRoundedUpFix2(double dValue) {
        return RoundHelper.getRoundedUpFix(dValue, 2);
    }

    public static double getRoundedEvenExp(double dValue, @Nonnegative int nScale) {
        return RoundHelper.getRounded(dValue, nScale, RoundingMode.HALF_EVEN, EDecimalType.EXP);
    }

    public static double getRoundedEvenExp2(double dValue) {
        return RoundHelper.getRoundedEvenExp(dValue, 2);
    }

    @Nonnull
    public static String getFormatted(double dValue, @Nonnegative int nScale, @Nonnull EDecimalType eType, @Nonnull Locale aLocale) {
        if (nScale < 0) {
            throw new IllegalArgumentException("Scale is too small: " + nScale);
        }
        if (eType == null) {
            throw new NullPointerException("type");
        }
        if (aLocale == null) {
            throw new NullPointerException("locale");
        }
        if (Double.isNaN(dValue) || Double.isInfinite(dValue)) {
            return Double.toString(dValue);
        }
        DecimalFormat aDF = new DecimalFormat();
        aDF.setDecimalFormatSymbols(DecimalFormatSymbolsFactory.getInstance(aLocale));
        aDF.setMaximumFractionDigits(nScale);
        aDF.setMinimumFractionDigits(nScale);
        if (eType.isExponential()) {
            String sPattern = "0E0";
            if (nScale > 0) {
                sPattern = sPattern + '.' + StringHelper.getRepeated('0', nScale);
            }
            aDF.applyPattern(sPattern);
        } else {
            aDF.setGroupingUsed(false);
            aDF.setMinimumIntegerDigits(1);
        }
        return aDF.format(dValue);
    }

    @Nonnull
    public static String getFormattedFix(double dValue, @Nonnegative int nScale, Locale aLocale) {
        return RoundHelper.getFormatted(dValue, nScale, EDecimalType.FIX, aLocale);
    }

    @Nonnull
    public static String getFormattedFix2(double dValue, Locale aLocale) {
        return RoundHelper.getFormattedFix(dValue, 2, aLocale);
    }

    @Nonnull
    public static String getFormattedExp(double dValue, @Nonnegative int nScale, Locale aLocale) {
        return RoundHelper.getFormatted(dValue, nScale, EDecimalType.EXP, aLocale);
    }

    @Nonnull
    public static String getFormattedExp2(double dValue, Locale aLocale) {
        return RoundHelper.getFormattedExp(dValue, 2, aLocale);
    }

    public static enum EDecimalType {
        FIX,
        EXP;


        public boolean isFixed() {
            return this == FIX;
        }

        public boolean isExponential() {
            return this == EXP;
        }
    }
}

