/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.convert.impl;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.locale.ComparatorLocale;
import com.phloc.commons.locale.LocaleCache;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.convert.IMicroTypeConverter;
import com.phloc.commons.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.phloc.commons.microdom.convert.IMicroTypeConverterRegistry;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.text.ISimpleMultiLingualText;
import com.phloc.commons.text.impl.MultiLingualText;
import com.phloc.commons.text.impl.ReadonlyMultiLingualText;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class MultiLingualTextMicroTypeConverterRegistrar
implements IMicroTypeConverterRegistrarSPI {
    private static final String ELEMENT_TEXT = "text";
    private static final String ATTR_LOCALE = "locale";

    @Override
    public void registerMicroTypeConverter(@Nonnull IMicroTypeConverterRegistry aRegistry) {
        aRegistry.registerMicroElementTypeConverter(ReadonlyMultiLingualText.class, new AbstractMLTConverter(){

            @Override
            @Nonnull
            public ReadonlyMultiLingualText convertToNative(@Nonnull IMicroElement aElement) {
                return new ReadonlyMultiLingualText(1.convertToMLT(aElement));
            }
        });
        aRegistry.registerMicroElementTypeConverter(MultiLingualText.class, new AbstractMLTConverter(){

            @Override
            @Nonnull
            public MultiLingualText convertToNative(@Nonnull IMicroElement aElement) {
                return 2.convertToMLT(aElement);
            }
        });
    }

    private static abstract class AbstractMLTConverter
    implements IMicroTypeConverter {
        private AbstractMLTConverter() {
        }

        @Override
        @Nonnull
        public final IMicroElement convertToMicroElement(@Nonnull Object aSource, @Nullable String sNamespaceURI, @Nonnull @Nonempty String sTagName) {
            ISimpleMultiLingualText aMLT = (ISimpleMultiLingualText)aSource;
            MicroElement eMText = new MicroElement(sNamespaceURI, sTagName);
            for (Locale aLocale : ContainerHelper.getSorted(aMLT.getAllLocales(), new ComparatorLocale())) {
                IMicroElement eText = eMText.appendElement(sNamespaceURI, MultiLingualTextMicroTypeConverterRegistrar.ELEMENT_TEXT);
                eText.setAttribute(MultiLingualTextMicroTypeConverterRegistrar.ATTR_LOCALE, aLocale.toString());
                eText.appendText(aMLT.getText(aLocale));
            }
            return eMText;
        }

        @Nonnull
        protected static final MultiLingualText convertToMLT(@Nonnull IMicroElement aElement) {
            MultiLingualText aMLT = new MultiLingualText();
            for (IMicroElement eText : aElement.getChildElements(MultiLingualTextMicroTypeConverterRegistrar.ELEMENT_TEXT)) {
                Locale aLocale = LocaleCache.getLocale(eText.getAttribute(MultiLingualTextMicroTypeConverterRegistrar.ATTR_LOCALE));
                aMLT.setText(aLocale, eText.getTextContent());
            }
            return aMLT;
        }
    }
}

