/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.regex;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RegExPattern {
    private static final AtomicBoolean s_aCheckConsistencyEnabled = new AtomicBoolean(false);
    private final String m_sRegEx;
    private final int m_nOptions;
    private Pattern m_aPattern;
    private Integer m_aHashCode;

    public static void checkPatternConsistency(@Nonnull @RegEx String sRegEx) throws IllegalArgumentException {
        int nIndex = 0;
        while (nIndex >= 0) {
            if ((nIndex = sRegEx.indexOf(36, nIndex)) == -1) continue;
            if (!(nIndex == sRegEx.length() - 1 || Character.isDigit(sRegEx.charAt(nIndex + 1)) || nIndex + 1 < sRegEx.length() && sRegEx.charAt(nIndex + 1) == ')' || nIndex > 0 && sRegEx.charAt(nIndex - 1) == '\\')) {
                throw new IllegalArgumentException("The passed regex '" + sRegEx + "' contains an unquoted '$' sign at index " + nIndex + "!");
            }
            ++nIndex;
        }
    }

    public RegExPattern(@Nonnull @RegEx @Nonempty String sRegEx) {
        this(sRegEx, 0);
    }

    public RegExPattern(@Nonnull @RegEx @Nonempty String sRegEx, @Nonnegative int nOptions) {
        if (StringHelper.hasNoText(sRegEx)) {
            throw new IllegalArgumentException("regEx is empty");
        }
        if (nOptions < 0) {
            throw new IllegalArgumentException("Options may not be < 0: " + nOptions);
        }
        this.m_sRegEx = sRegEx;
        this.m_nOptions = nOptions;
        if (RegExPattern.areDebugConsistencyChecksEnabled()) {
            RegExPattern.checkPatternConsistency(sRegEx);
        }
        try {
            this.m_aPattern = Pattern.compile(this.m_sRegEx, this.m_nOptions);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("Regular expression '" + this.m_sRegEx + "' is illegal" + (this.m_nOptions == 0 ? "" : " with options " + this.m_nOptions), ex);
        }
    }

    @Nonnull
    @RegEx
    @Nonempty
    public String getRegEx() {
        return this.m_sRegEx;
    }

    @Nonnegative
    public int getOptions() {
        return this.m_nOptions;
    }

    @Nonnull
    public Pattern getAsPattern() {
        return this.m_aPattern;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegExPattern)) {
            return false;
        }
        RegExPattern rhs = (RegExPattern)o;
        return this.m_sRegEx.equals(rhs.m_sRegEx) && this.m_nOptions == rhs.m_nOptions;
    }

    public int hashCode() {
        if (this.m_aHashCode == null) {
            this.m_aHashCode = new HashCodeGenerator(this).append(this.m_sRegEx).append(this.m_nOptions).getHashCodeObj();
        }
        return this.m_aHashCode;
    }

    public String toString() {
        return new ToStringGenerator(this).append("regex", this.m_sRegEx).append("options", this.m_nOptions).toString();
    }

    public static boolean areDebugConsistencyChecksEnabled() {
        return s_aCheckConsistencyEnabled.get();
    }

    public static void enableDebugConsistencyChecks(boolean bEnable) {
        s_aCheckConsistencyEnabled.set(bEnable);
    }
}

