/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.type;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ObjectType
implements Comparable<ObjectType>,
Serializable {
    private final String m_sName;
    private Integer m_aHashCode;

    public ObjectType(@Nonnull @Nonempty String sName) {
        if (StringHelper.hasNoText(sName)) {
            throw new IllegalArgumentException("name");
        }
        this.m_sName = sName;
    }

    @Nonnull
    @Nonempty
    public String getObjectTypeName() {
        return this.m_sName;
    }

    @Override
    public int compareTo(@Nonnull ObjectType aObjType) {
        return this.m_sName.compareTo(aObjType.m_sName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectType)) {
            return false;
        }
        ObjectType rhs = (ObjectType)o;
        return this.m_sName.equals(rhs.m_sName);
    }

    public int hashCode() {
        if (this.m_aHashCode == null) {
            this.m_aHashCode = new HashCodeGenerator(this).append(this.m_sName).getHashCodeObj();
        }
        return this.m_aHashCode;
    }

    public String toString() {
        return new ToStringGenerator(this).append("name", this.m_sName).toString();
    }
}

