/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.utils;

import com.phloc.commons.callback.AdapterRunnableToCallable;
import com.phloc.commons.callback.IThrowingRunnable;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.timing.StopWatch;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainRunner {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MainRunner.class);
    private static final IStatisticsHandlerTimer s_aTimerHdl = StatisticsManager.getTimerHandler(MainRunner.class);
    private static final MainRunner s_aInstance = new MainRunner();

    private MainRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(@Nonnull IThrowingRunnable aRunnable) {
        if (aRunnable == null) {
            throw new NullPointerException("runnable");
        }
        StopWatch aSW = new StopWatch(true);
        try {
            aRunnable.run();
        }
        catch (Throwable t) {
            s_aLogger.error("Error running application", t);
        }
        finally {
            s_aTimerHdl.addTime(aSW.stopAndGetMillis());
        }
    }

    public static void run(@Nonnull Runnable aRunnable) {
        MainRunner.run(AdapterRunnableToCallable.createAdapter(aRunnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <DATATYPE> DATATYPE run(@Nonnull Callable<DATATYPE> aCallable) {
        if (aCallable == null) {
            throw new NullPointerException("runnable");
        }
        StopWatch aSW = new StopWatch(true);
        try {
            DATATYPE DATATYPE = aCallable.call();
            return DATATYPE;
        }
        catch (Throwable t) {
            s_aLogger.error("Error running application", t);
            DATATYPE DATATYPE = null;
            return DATATYPE;
        }
        finally {
            s_aTimerHdl.addTime(aSW.stopAndGetMillis());
        }
    }
}

