/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamSource;

@NotThreadSafe
public final class CachingTransformStreamSource
extends StreamSource {
    public CachingTransformStreamSource(@Nonnull IReadableResource aResource) {
        this(aResource.getInputStream(), aResource.getResourceID());
    }

    public CachingTransformStreamSource(@Nonnull IInputStreamProvider aIIS) {
        this(aIIS, null);
    }

    public CachingTransformStreamSource(@Nonnull IInputStreamProvider aIIS, @Nullable String sSystemID) {
        this(aIIS.getInputStream(), sSystemID);
    }

    public CachingTransformStreamSource(@Nonnull @WillClose InputStream aIS) {
        this(aIS, null);
    }

    public CachingTransformStreamSource(@Nonnull @WillClose InputStream aIS, @Nullable String sSystemID) {
        super(new NonBlockingByteArrayInputStream(StreamUtils.getAllBytes(aIS)), sSystemID);
    }

    public String toString() {
        return new ToStringGenerator(this).append("systemID", this.getSystemId()).toString();
    }
}

