/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSKeyframesBlock;
import com.phloc.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSKeyframesRule
implements ICSSTopLevelRule,
ICSSVersionAware {
    private final String m_sDeclaration;
    private final String m_sAnimationName;
    private final List<CSSKeyframesBlock> m_aBlocks = new ArrayList<CSSKeyframesBlock>();

    public CSSKeyframesRule(@Nonnull @Nonempty String sDeclaration, @Nonnull @Nonempty String sAnimationName) {
        if (StringHelper.hasNoText((CharSequence)sDeclaration)) {
            throw new IllegalArgumentException("declaration");
        }
        this.m_sDeclaration = sDeclaration;
        this.m_sAnimationName = sAnimationName;
    }

    @Nonnull
    @Nonempty
    public String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Nonnull
    @Nonempty
    public String getAnimationName() {
        return this.m_sAnimationName;
    }

    public void addBlock(@Nonnull CSSKeyframesBlock aKeyframesBlock) {
        if (aKeyframesBlock == null) {
            throw new NullPointerException("keyframesBlock");
        }
        this.m_aBlocks.add(aKeyframesBlock);
    }

    @Nonnull
    public EChange removeBlock(@Nonnull CSSKeyframesBlock aKeyframesBlock) {
        return EChange.valueOf((boolean)this.m_aBlocks.remove(aKeyframesBlock));
    }

    @Nonnull
    public EChange removeBlock(@Nonnegative int nBlockIndex) {
        if (nBlockIndex < 0 || nBlockIndex >= this.m_aBlocks.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aBlocks.remove(nBlockIndex) != null ? 1 : 0) != 0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSKeyframesBlock> getAllBlocks() {
        return ContainerHelper.newList(this.m_aBlocks);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        if (!aSettings.isWriteKeyframesRules()) {
            return "";
        }
        if (aSettings.isRemoveUnnecessaryCode() && this.m_aBlocks.isEmpty()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder(this.m_sDeclaration);
        aSB.append(' ').append(this.m_sAnimationName).append(bOptimizedOutput ? "{" : " {");
        if (!bOptimizedOutput) {
            aSB.append('\n');
        }
        for (CSSKeyframesBlock aBlock : this.m_aBlocks) {
            String sBlockCSS = aBlock.getAsCSSString(aSettings, nIndentLevel + 1);
            if (!StringHelper.hasText((CharSequence)sBlockCSS)) continue;
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel + 1));
            }
            aSB.append(sBlockCSS);
            if (bOptimizedOutput) continue;
            aSB.append('\n');
        }
        if (!bOptimizedOutput) {
            aSB.append(aSettings.getIndent(nIndentLevel));
        }
        aSB.append('}');
        if (!bOptimizedOutput) {
            aSB.append('\n');
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSKeyframesRule)) {
            return false;
        }
        CSSKeyframesRule rhs = (CSSKeyframesRule)o;
        return this.m_sDeclaration.equals(rhs.m_sDeclaration) && this.m_sAnimationName.equals(rhs.m_sAnimationName) && ((Object)this.m_aBlocks).equals(rhs.m_aBlocks);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDeclaration).append((Object)this.m_sAnimationName).append(this.m_aBlocks).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declaration", (Object)this.m_sDeclaration).append("animationName", (Object)this.m_sAnimationName).append("blocks", this.m_aBlocks).toString();
    }
}

