/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.writer;

import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.io.streams.NonBlockingStringWriter;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.vendor.VendorInfo;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclarationList;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.writer.CSSWriterSettings;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSWriter {
    public static final boolean DEFAULT_OPTIMIZED_OUTPUT = false;
    private final CSSWriterSettings m_aSettings;
    private boolean m_bWriteHeaderText;
    private String m_sHeaderText = StringHelper.getImploded((String)"\n", (Iterable)VendorInfo.getFileHeaderLines());
    private String m_sContentCharset;

    public CSSWriter(@Nonnull ECSSVersion eVersion) {
        this(eVersion, false);
    }

    public CSSWriter(@Nonnull ECSSVersion eVersion, boolean bOptimizedOutput) {
        this(new CSSWriterSettings(eVersion, bOptimizedOutput));
    }

    public CSSWriter(@Nonnull CSSWriterSettings aSettings) {
        if (aSettings == null) {
            throw new NullPointerException("settings");
        }
        this.m_aSettings = aSettings;
        this.m_bWriteHeaderText = !aSettings.isOptimizedOutput();
    }

    public boolean isWriteHeaderText() {
        return this.m_bWriteHeaderText;
    }

    @Nonnull
    public CSSWriter setWriteHeaderText(boolean bWriteHeaderText) {
        this.m_bWriteHeaderText = bWriteHeaderText;
        return this;
    }

    @Nullable
    public String getHeaderText() {
        return this.m_sHeaderText;
    }

    @Nonnull
    public CSSWriter setHeaderText(@Nullable String sHeaderText) {
        this.m_sHeaderText = sHeaderText;
        return this;
    }

    @Nullable
    public String getContentCharset() {
        return this.m_sContentCharset;
    }

    @Nonnull
    public CSSWriter setContentCharset(@Nullable String sContentCharset) {
        this.m_sContentCharset = sContentCharset;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject(reason="Design")
    public CSSWriterSettings getSettings() {
        return this.m_aSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCSS(@Nonnull CascadingStyleSheet aCSS, @Nonnull @WillClose Writer aWriter) throws IOException {
        if (aCSS == null) {
            throw new NullPointerException("css");
        }
        if (aWriter == null) {
            throw new NullPointerException("writer");
        }
        try {
            boolean bOptimizedOutput = this.m_aSettings.isOptimizedOutput();
            if (this.m_bWriteHeaderText && StringHelper.hasText((CharSequence)this.m_sHeaderText)) {
                aWriter.write("/*\n");
                for (String sLine : StringHelper.getExploded((String)"\n", (String)this.m_sHeaderText)) {
                    aWriter.write(" * " + sLine + "\n");
                }
                aWriter.write(" */\n");
            }
            if (StringHelper.hasText((CharSequence)this.m_sContentCharset)) {
                aWriter.write("@charset \"" + this.m_sContentCharset + "\"\n");
                if (!bOptimizedOutput) {
                    aWriter.write(10);
                }
            }
            int nRulesEmitted = 0;
            List<CSSImportRule> aImportRules = aCSS.getAllImportRules();
            if (!aImportRules.isEmpty()) {
                for (CSSImportRule aImportRule : aImportRules) {
                    aWriter.write(aImportRule.getAsCSSString(this.m_aSettings, 0));
                    ++nRulesEmitted;
                }
            }
            for (ICSSTopLevelRule aRule : aCSS.getAllRules()) {
                String sRuleCSS = aRule.getAsCSSString(this.m_aSettings, 0);
                if (!StringHelper.hasText((CharSequence)sRuleCSS)) continue;
                if (!bOptimizedOutput && nRulesEmitted > 0) {
                    aWriter.write(10);
                }
                aWriter.write(sRuleCSS);
                ++nRulesEmitted;
            }
        }
        finally {
            StreamUtils.close((Closeable)aWriter);
        }
    }

    @Deprecated
    public void writeCSS(@Nonnull CascadingStyleSheet aCSS, @Nonnull @WillClose Writer aWriter, @Nullable String sCSSCharset) throws IOException {
        this.writeCSS(aCSS, aWriter);
    }

    @Nonnull
    public String getCSSAsString(@Nonnull CascadingStyleSheet aCSS) throws IOException {
        NonBlockingStringWriter aSW = new NonBlockingStringWriter();
        this.writeCSS(aCSS, (Writer)aSW);
        return aSW.getAsString();
    }

    @Nonnull
    @Deprecated
    public String getCSSAsString(@Nonnull CascadingStyleSheet aCSS, @Nullable String sCSSCharset) throws IOException {
        return this.getCSSAsString(aCSS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCSS(@Nonnull CSSDeclarationList aCSS, @Nonnull @WillClose Writer aWriter) throws IOException {
        if (aCSS == null) {
            throw new NullPointerException("css");
        }
        if (aWriter == null) {
            throw new NullPointerException("writer");
        }
        try {
            aWriter.write(aCSS.getAsCSSString(this.m_aSettings, 0));
        }
        finally {
            StreamUtils.close((Closeable)aWriter);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull CSSDeclarationList aCSS) throws IOException {
        NonBlockingStringWriter aSW = new NonBlockingStringWriter();
        this.writeCSS(aCSS, (Writer)aSW);
        return aSW.getAsString();
    }
}

