/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.OverlapDetector;
import java.util.Vector;

class DuplicateAttributeDetector {
    private final Vector nameClasses = new Vector();
    private Alternative alternatives = null;

    DuplicateAttributeDetector() {
    }

    boolean addAttribute(NameClass nameClass) {
        int n = this.nameClasses.size();
        Alternative alternative = this.alternatives;
        while (alternative != null) {
            for (int i = alternative.endIndex; i < n; ++i) {
                if (!OverlapDetector.overlap(nameClass, (NameClass)this.nameClasses.elementAt(i))) continue;
                return false;
            }
            n = alternative.startIndex;
            alternative = alternative.parent;
        }
        for (int i = 0; i < n; ++i) {
            if (!OverlapDetector.overlap(nameClass, (NameClass)this.nameClasses.elementAt(i))) continue;
            return false;
        }
        this.nameClasses.addElement(nameClass);
        return true;
    }

    void startChoice() {
        this.alternatives = new Alternative(this.nameClasses.size(), this.alternatives);
    }

    void alternative() {
        this.alternatives.endIndex = this.nameClasses.size();
    }

    void endChoice() {
        this.alternatives = this.alternatives.parent;
    }

    private static class Alternative {
        private final int startIndex;
        private int endIndex;
        private final Alternative parent;

        private Alternative(int n, Alternative alternative) {
            this.startIndex = n;
            this.endIndex = n;
            this.parent = alternative;
        }
    }
}

