/*
 * Decompiled with CFR 0.152.
 */
package com.schematron.ant;

import com.schematron.ant.Validator;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;

public final class ValidatorFactory {
    private static final String INCLUDE_PREPROCESSOR = "/iso_dsdl_include.xsl";
    private static final String ABSTRACT_PREPROCESSOR = "/iso_abstract_expand.xsl";
    private static final String PREPROCESSOR_MESSAGE_OLD = "/schematron-message1-6_XT.xsl";
    private static final String PREPROCESSOR_MESSAGE_XSLT1 = "/iso_schematron_message.xsl";
    private static final String PREPROCESSOR_MESSAGE_XSLT2 = "/iso_schematron_message_xslt2.xsl";
    private static final String PREPROCESSOR_SVRL_XSLT1 = "/iso_svrl_for_xslt1.xsl";
    private static final String PREPROCESSOR_SVRL_XSLT2 = "/iso_svrl_for_xslt2.xsl";
    private static final String PREPROCESSOR_SVRL_OLD = "/iso_svrl_1.6.xsl";
    private static final String PREPROCESSOR_TERMINATE_XSLT1 = "/iso_svrl_for_xslt1.xsl";
    private static final String PREPROCESSOR_TERMINATE_XSLT2 = "/iso_svrl_for_xslt2.xsl";
    private static final String PREPROCESSOR_TERMINATE_OLD = "/iso_svrl_1.6.xsl";
    private String thePreprocessor = "/iso_svrl_for_xslt1.xsl";
    private TransformerFactory _factory = TransformerFactoryImpl.newInstance();
    private Class _resolver;
    private ErrorListener _listener = this._factory.getErrorListener();
    private Hashtable _parameters = new Hashtable();
    private final Source _abstract_preprocessor;
    private final Source _include_preprocessor;
    private final Source _preprocessor;
    private boolean debugMode = false;

    public ValidatorFactory() {
        this._preprocessor = this.resolveDefaultPreprocessor();
        this._include_preprocessor = this.resolvePreprocessor(INCLUDE_PREPROCESSOR);
        this._abstract_preprocessor = this.resolvePreprocessor(ABSTRACT_PREPROCESSOR);
    }

    public ValidatorFactory(Source preprocessor) throws IllegalArgumentException {
        if (preprocessor == null) {
            throw new IllegalArgumentException("The preprocessor must not be null.");
        }
        this._preprocessor = preprocessor;
        this._include_preprocessor = this.resolvePreprocessor(INCLUDE_PREPROCESSOR);
        this._abstract_preprocessor = this.resolvePreprocessor(ABSTRACT_PREPROCESSOR);
    }

    public ValidatorFactory(String preprocessor, String formatter) throws IllegalArgumentException {
        if (preprocessor == null) {
            throw new IllegalArgumentException("The preprocessor must not be null.");
        }
        this.thePreprocessor = preprocessor.equalsIgnoreCase("xslt2") || preprocessor.equalsIgnoreCase("xpath2") ? (formatter.equalsIgnoreCase("message") ? PREPROCESSOR_MESSAGE_XSLT2 : (formatter.equalsIgnoreCase("message") ? "/iso_svrl_for_xslt2.xsl" : "/iso_svrl_for_xslt2.xsl")) : (preprocessor.equalsIgnoreCase("xslt") || preprocessor.equalsIgnoreCase("xpath") || preprocessor.equalsIgnoreCase("xslt1") ? (formatter.equalsIgnoreCase("message") ? PREPROCESSOR_MESSAGE_XSLT1 : (formatter.equalsIgnoreCase("message") ? "/iso_svrl_for_xslt1.xsl" : "/iso_svrl_for_xslt1.xsl")) : (preprocessor.equalsIgnoreCase("1.5") || preprocessor.equalsIgnoreCase("1.6") || preprocessor.equalsIgnoreCase("old") ? (formatter.equalsIgnoreCase("message") ? PREPROCESSOR_MESSAGE_OLD : (formatter.equalsIgnoreCase("message") ? "/iso_svrl_1.6.xsl" : "/iso_svrl_1.6.xsl")) : (formatter.equalsIgnoreCase("message") ? PREPROCESSOR_MESSAGE_XSLT1 : (formatter.equalsIgnoreCase("terminate") ? "/iso_svrl_for_xslt1.xsl" : "/iso_svrl_for_xslt1.xsl"))));
        this._preprocessor = this.resolvePreprocessor();
        this._include_preprocessor = this.resolvePreprocessor(INCLUDE_PREPROCESSOR);
        this._abstract_preprocessor = this.resolvePreprocessor(ABSTRACT_PREPROCESSOR);
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The error listener must not be null.");
        }
        this._listener = listener;
    }

    public ErrorListener getErrorListener() {
        return this._listener;
    }

    public void setParameter(String name, Object value) {
        this._parameters.put(name, value);
    }

    public Object getParameter(String name) {
        return this._parameters.get(name);
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setResolver(Class theResolver) {
        this._resolver = theResolver;
    }

    private Source resolveDefaultPreprocessor() throws TransformerFactoryConfigurationError {
        URL url = ValidatorFactory.class.getResource("/iso_svrl_for_xslt1.xsl");
        if (url == null) {
            throw new TransformerFactoryConfigurationError("preprocessor '/iso_svrl_for_xslt1.xsl' cannot be found in the classpath.");
        }
        return new StreamSource(url.toString());
    }

    private Source resolvePreprocessor() throws TransformerFactoryConfigurationError {
        URL url = ValidatorFactory.class.getResource(this.thePreprocessor);
        if (url == null) {
            throw new TransformerFactoryConfigurationError("preprocessor '" + this.thePreprocessor + "' cannot be found in the classpath.");
        }
        return new StreamSource(url.toString());
    }

    private Source resolvePreprocessor(String stylesheet) throws TransformerFactoryConfigurationError {
        URL url = ValidatorFactory.class.getResource(stylesheet);
        if (url == null) {
            throw new TransformerFactoryConfigurationError("preprocessor '" + stylesheet + "' cannot be found in the classpath.");
        }
        return new StreamSource(url.toString());
    }

    public Validator newValidator(Source schema) throws TransformerException, IOException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Transformer include_transformer = this._factory.newTransformer(this._include_preprocessor);
        Transformer abstract_transformer = this._factory.newTransformer(this._abstract_preprocessor);
        this._factory.setURIResolver(new XSLTURIFinder());
        Transformer transformer = this._factory.newTransformer(this._preprocessor);
        include_transformer.setErrorListener(this._listener);
        abstract_transformer.setErrorListener(this._listener);
        transformer.setErrorListener(this._listener);
        if (!this._parameters.isEmpty()) {
            Enumeration names = this._parameters.keys();
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                transformer.setParameter(name, this._parameters.get(name));
                abstract_transformer.setParameter(name, this._parameters.get(name));
                include_transformer.setParameter(name, this._parameters.get(name));
            }
        }
        if (!this._factory.getFeature("http://javax.xml.transform.stream.StreamResult/feature")) {
            throw new TransformerConfigurationException("The XSLT processor must support following feature: http://javax.xml.transform.stream.StreamResult/feature");
        }
        Interim interim = new Interim(schema.getSystemId());
        DOMResult r1 = new DOMResult();
        include_transformer.transform(schema, r1);
        DOMResult r2 = new DOMResult();
        DOMSource s2 = new DOMSource(r1.getNode());
        abstract_transformer.transform(s2, r2);
        r1 = null;
        DOMSource s3 = new DOMSource(r2.getNode());
        transformer.transform(s3, interim.makeEmptyResult());
        r2 = null;
        if (this.debugMode) {
            interim.saveAs(new File("debug.xslt"));
        }
        if (this._resolver != null) {
            this._factory.setURIResolver((URIResolver)this._resolver.newInstance());
        }
        Templates validator = this._factory.newTemplates(interim.getSource());
        return new Validator(validator);
    }

    private static class Interim {
        private StringWriter writer;
        private final String systemId;

        public Interim(String systemId) {
            this.systemId = systemId;
        }

        public Result makeEmptyResult() throws IllegalStateException, UnsupportedEncodingException {
            if (this.writer != null) {
                throw new IllegalStateException("The templates have already been produced.");
            }
            this.writer = new StringWriter();
            return new StreamResult(this.writer);
        }

        public Source getSource() throws IllegalStateException {
            if (this.writer == null) {
                throw new IllegalStateException("The templates have not been produced.");
            }
            StreamSource source = new StreamSource(new StringReader(this.writer.toString()));
            source.setPublicId("compiled:" + this.systemId);
            return source;
        }

        public void saveAs(File file) throws IOException {
            PrintStream pout = new PrintStream(file, "utf-8");
            pout.print(this.writer.toString());
            pout.close();
        }
    }

    private static class XSLTURIFinder
    implements URIResolver {
        private XSLTURIFinder() {
        }

        public Source resolve(String href, String base) {
            URL url;
            try {
                if (href == null || href.length() == 0) {
                    int bang = base.indexOf("!");
                    url = ValidatorFactory.class.getResource(base.substring(bang + 1));
                } else {
                    url = href.contains(":") ? ValidatorFactory.class.getResource(href) : ValidatorFactory.class.getResource("/" + href);
                }
            }
            catch (Exception e) {
                return null;
            }
            return new StreamSource(url.toString());
        }
    }
}

