/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.acl;

import java.net.InetAddress;
import java.util.Hashtable;
import org.w3c.jigsaw.acl.AclPrincipal;
import org.w3c.jigsaw.auth.AuthUser;
import org.w3c.jigsaw.auth.IPMatcher;

public class AuthUserPrincipal
implements AclPrincipal {
    protected String name = null;
    protected String password = null;
    protected String realm = null;
    protected Hashtable values = null;
    protected IPMatcher ipmatcher = null;

    public boolean equals(Object object) {
        if (object instanceof AuthUserPrincipal) {
            return this.toString().equals(object.toString());
        }
        return object.equals(this);
    }

    public String toString() {
        if (this.password == null) {
            return this.name;
        }
        return this.name + ":" + this.password;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getPassword() {
        return this.password;
    }

    public void setValue(String string, Object object) {
        this.values.put(string, object);
    }

    public Object getValue(String string) {
        return this.values.get(string);
    }

    public boolean matchIP(InetAddress inetAddress) {
        return this.ipmatcher.lookup(inetAddress) == Boolean.TRUE;
    }

    public AuthUserPrincipal(AuthUser authUser, String string) {
        this.name = authUser.getName();
        this.password = authUser.getPassword();
        this.realm = string;
        this.ipmatcher = new IPMatcher();
        this.values = new Hashtable();
        short[][] sArray = authUser.getIPTemplates();
        if (sArray != null) {
            for (int i = 0; i < sArray.length; ++i) {
                this.ipmatcher.add(sArray[i], Boolean.TRUE);
            }
        }
    }
}

