/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import org.w3c.jigsaw.filters.Cache;
import org.w3c.jigsaw.filters.CacheEntry;
import org.w3c.jigsaw.filters.CacheException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FilterInterface;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;

public class CacheFilter
extends ResourceFilter {
    protected Cache cache = null;
    protected static final String STATE_TAG = "org.w3c.jigsaw.filters.CacheFilter.tag";
    protected static int ATTR_MAX_SIZE = -1;
    protected static int ATTR_MAX_ENTRIES = -1;
    protected static int ATTR_DEFAULT_MAX_AGE = -1;

    public int getMaxSize() {
        return (Integer)this.getValue(ATTR_MAX_SIZE, (Object)new Integer(-1));
    }

    public int getMaxEntries() {
        return (Integer)this.getValue(ATTR_MAX_ENTRIES, (Object)new Integer(-1));
    }

    public int getDefaultMaxAge() {
        return (Integer)this.getValue(ATTR_DEFAULT_MAX_AGE, (Object)new Integer(300));
    }

    private final void tag(Request request) {
        request.setState(STATE_TAG, Boolean.TRUE);
    }

    private final boolean isTagged(Request request) {
        return request.hasState(STATE_TAG);
    }

    private Reply applyIn(Request request, FilterInterface[] filterInterfaceArray, int n) throws ProtocolException {
        Reply reply = null;
        for (int i = n + 1; i < filterInterfaceArray.length && filterInterfaceArray[i] != null; ++i) {
            reply = (Reply)filterInterfaceArray[i].ingoingFilter(request, filterInterfaceArray, i);
            if (reply == null) continue;
            return reply;
        }
        return null;
    }

    private Reply applyOut(Request request, Reply reply, FilterInterface[] filterInterfaceArray, int n) throws ProtocolException {
        Reply reply2 = null;
        for (int i = n - 1; i >= 0 && filterInterfaceArray[i] != null; --i) {
            reply2 = (Reply)filterInterfaceArray[i].outgoingFilter(request, reply, filterInterfaceArray, i);
            if (reply2 == null) continue;
            return reply2;
        }
        return null;
    }

    private final Reply applyOut(Request request, Reply reply, FilterInterface[] filterInterfaceArray) throws ProtocolException {
        return this.applyOut(request, reply, filterInterfaceArray, filterInterfaceArray.length);
    }

    private void makeInconditional(Request request) {
        request.setHeaderValue(Request.H_IF_MATCH, null);
        request.setHeaderValue(Request.H_IF_MODIFIED_SINCE, null);
        request.setHeaderValue(Request.H_IF_NONE_MATCH, null);
        request.setHeaderValue(Request.H_IF_RANGE, null);
        request.setHeaderValue(Request.H_IF_UNMODIFIED_SINCE, null);
    }

    public ReplyInterface ingoingFilter(RequestInterface requestInterface, FilterInterface[] filterInterfaceArray, int n) throws ProtocolException {
        String string;
        Request request = (Request)requestInterface;
        if (this.cache == null) {
            this.cache = new Cache(this.getMaxSize(), this.getMaxEntries(), this.getDefaultMaxAge());
        }
        if (!(string = request.getMethod()).equals("HEAD") && !string.equals("GET")) {
            return null;
        }
        this.tag(request);
        if (this.isCachable(request)) {
            CacheEntry cacheEntry = this.cache.retrieve(request);
            if (cacheEntry != null) {
                System.out.println("**** Examining entry: " + cacheEntry);
                Reply reply = null;
                if (cacheEntry.isFresh(request)) {
                    reply = this.applyIn(request, filterInterfaceArray, n);
                    if (reply != null) {
                        return reply;
                    }
                    Reply reply2 = cacheEntry.getReply(request);
                    reply = this.applyOut(request, reply2, filterInterfaceArray);
                    if (reply != null) {
                        return reply;
                    }
                    System.out.println("**** Replying from cache");
                    return reply2;
                }
                cacheEntry.makeConditional(request);
                return null;
            }
            System.out.println("**** Not in cache");
        } else {
            System.out.println("**** Request not cachable");
        }
        this.makeInconditional(request);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface, FilterInterface[] filterInterfaceArray, int n) throws ProtocolException {
        Object object;
        Reply reply;
        Request request;
        block13: {
            block12: {
                request = (Request)requestInterface;
                reply = (Reply)replyInterface;
                if (!this.isTagged(request)) {
                    return null;
                }
                if (!this.isCachable(reply)) break block12;
                switch (reply.getStatus()) {
                    case 200: 
                    case 204: 
                    case 300: 
                    case 301: {
                        try {
                            this.cache.store(request, reply);
                        }
                        catch (CacheException cacheException) {}
                        finally {
                            return null;
                        }
                    }
                    case 304: {
                        object = this.cache.retrieve(request);
                        if (object != null) {
                            reply = ((CacheEntry)object).getReply(request, reply);
                            break;
                        }
                        break block13;
                    }
                    default: {
                        this.cache.remove(request);
                        return null;
                    }
                }
                break block13;
            }
            System.out.println("**** Reply not cachable");
            this.cache.remove(request);
        }
        object = this.applyOut(request, reply, filterInterfaceArray, n);
        if (object != null) {
            return object;
        }
        return reply;
    }

    private boolean isCachable(Request request) {
        if (request.checkNoStore()) {
            return false;
        }
        String[] stringArray = request.getNoCache();
        return stringArray == null;
    }

    private boolean isCachable(Reply reply) {
        return !reply.checkNoStore() && reply.getPrivate() == null;
    }

    static {
        IntegerAttribute integerAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.filters.CacheFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("maxSize", new Integer(8192), 2);
        ATTR_MAX_SIZE = AttributeRegistry.registerAttribute(clazz, integerAttribute);
        integerAttribute = new IntegerAttribute("maxEntries", new Integer(-1), 2);
        ATTR_MAX_ENTRIES = AttributeRegistry.registerAttribute(clazz, integerAttribute);
        integerAttribute = new IntegerAttribute("defaultMaxAge", new Integer(300), 2);
        ATTR_DEFAULT_MAX_AGE = AttributeRegistry.registerAttribute(clazz, integerAttribute);
    }
}

