/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.indexer;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.indexer.ContentTypesIndexerEnumeration;
import org.w3c.tools.resources.DummyResourceReference;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.indexer.SampleResourceIndexer;
import org.w3c.tools.resources.indexer.TemplateContainer;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public class ContentTypeIndexer
extends SampleResourceIndexer {
    private static final boolean debug = false;
    protected ResourceReference contentTypes = null;

    public Enumeration enumerateResourceIdentifiers(boolean bl) {
        return new ContentTypesIndexerEnumeration();
    }

    protected synchronized ResourceReference getContentTypes() {
        if (this.contentTypes == null) {
            String string = this.getIdentifier() + "-c";
            this.contentTypes = new DummyResourceReference(new TemplateContainer(new ResourceContext(this.getContext()), string + ".db"));
        }
        return this.contentTypes;
    }

    public ResourceReference lookup(String string) {
        if (string.equals("directories")) {
            return this.getDirectories();
        }
        if (string.equals("extensions")) {
            return this.getExtensions();
        }
        if (string.equals("content-types")) {
            return this.getContentTypes();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete() throws MultipleLockException {
        DummyResourceReference dummyResourceReference = (DummyResourceReference)this.getContentTypes();
        try {
            Resource resource = dummyResourceReference.lock();
            resource.delete();
        }
        catch (InvalidResourceException invalidResourceException) {
        }
        finally {
            dummyResourceReference.invalidate();
            dummyResourceReference.unlock();
        }
        super.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResourceReference loadContentType(String string) {
        MimeType mimeType = null;
        try {
            mimeType = new MimeType(string);
        }
        catch (MimeTypeFormatException mimeTypeFormatException) {
            return null;
        }
        ResourceReference resourceReference = this.getContentTypes();
        try {
            Object object;
            TemplateContainer templateContainer = (TemplateContainer)resourceReference.lock();
            Enumeration enumeration = templateContainer.enumerateResourceIdentifiers(true);
            Object object2 = "*:*";
            int n = -1;
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                MimeType mimeType2 = null;
                try {
                    mimeType2 = new MimeType(((String)object).replace(':', '/'));
                }
                catch (MimeTypeFormatException mimeTypeFormatException) {
                    continue;
                }
                int n2 = mimeType.match(mimeType2);
                if (n2 <= n) continue;
                n = n2;
                object2 = object;
                if (n != 4) continue;
                break;
            }
            object = templateContainer.lookup((String)object2);
            return object;
        }
        catch (InvalidResourceException invalidResourceException) {
            String string2 = "[resource indexer]: content-types \"" + string + "\" couldn't be restored (" + invalidResourceException.getMessage() + ")";
            this.getContext().getServer().errlog(string2);
            ResourceReference resourceReference2 = null;
            return resourceReference2;
        }
        finally {
            resourceReference.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource createFileResource(File file, RequestInterface requestInterface, String string, Hashtable hashtable) {
        ResourceReference resourceReference = null;
        FramedResource framedResource = null;
        if (requestInterface instanceof Request) {
            Request request = (Request)requestInterface;
            MimeType mimeType = request.getContentType();
            if (mimeType != null) {
                resourceReference = this.loadContentType(mimeType.toString());
            }
            if (resourceReference != null) {
                String string2 = "directory".intern();
                String string3 = "identifier".intern();
                String string4 = "filename".intern();
                String string5 = "context".intern();
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Object>(5);
                }
                if (hashtable.get(string2) == null) {
                    hashtable.put(string2, file);
                }
                if (hashtable.get(string3) == null) {
                    hashtable.put(string3, string);
                }
                if (hashtable.get(string5) == null) {
                    hashtable.put(string5, this.getContext());
                }
                try {
                    framedResource = (FramedResource)resourceReference.lock();
                    try {
                        FramedResource framedResource2 = null;
                        framedResource2 = (FramedResource)framedResource.getClone(hashtable);
                        String[] stringArray = request.getContentLanguage();
                        String[] stringArray2 = request.getContentEncoding();
                        Class<?> clazz = Class.forName("org.w3c.jigsaw.frames.HTTPFrame");
                        HTTPFrame hTTPFrame = (HTTPFrame)framedResource2.getFrame(clazz);
                        if (hTTPFrame != null) {
                            if (stringArray != null && stringArray.length > 0) {
                                hTTPFrame.setValue("content-language", (Object)stringArray[0]);
                            }
                            if (stringArray2 != null && stringArray2.length > 0) {
                                hTTPFrame.setValue("content-encoding", (Object)stringArray2[0]);
                            }
                        }
                        FramedResource framedResource3 = framedResource2;
                        return framedResource3;
                    }
                    catch (Exception exception) {
                        try {
                            exception.printStackTrace();
                            resourceReference.unlock();
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            invalidResourceException.printStackTrace();
                        }
                    }
                }
                finally {
                    resourceReference.unlock();
                }
            }
        }
        return super.createFileResource(file, requestInterface, string, hashtable);
    }
}

