/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jpeg;

import java.util.Hashtable;
import org.w3c.tools.jpeg.ExifData;
import org.w3c.tools.jpeg.TagDecoder;

public class Exif {
    private static final int TAG_EXIF_OFFSET = 34665;
    private static final int TAG_INTEROP_OFFSET = 40965;
    private Hashtable tags = new Hashtable();
    private Hashtable exif = new Hashtable();
    private Hashtable decoder = new Hashtable();
    private ExifData data = null;
    private boolean intelOrder = false;
    private String tagHeight = null;
    private String tagWidth = null;
    private String tagComp = null;
    private String tagBPP = null;
    private String tagNumCC = null;

    public void parseExif(byte[] byArray) {
        this.data = new ExifData(byArray);
        if (!this.data.isExifData()) {
            return;
        }
        int n = this.data.get32u(10);
        this.processExifDir(6 + n, 6);
    }

    public void setHeight(int n) {
        if (this.tagHeight != null) {
            this.exif.put(this.tagHeight, "" + n);
        }
    }

    public void setWidth(int n) {
        if (this.tagWidth != null) {
            this.exif.put(this.tagWidth, "" + n);
        }
    }

    public void setCompression(String string) {
        if (this.tagComp != null) {
            this.exif.put(this.tagComp, string);
        }
    }

    public void setBPP(int n) {
        if (this.tagBPP != null) {
            this.exif.put(this.tagBPP, "" + n);
        }
    }

    public void setNumCC(int n) {
        if (this.tagNumCC != null) {
            this.exif.put(this.tagNumCC, "" + n);
        }
    }

    public void addHeight(String string) {
        this.tagHeight = string;
    }

    public void addWidth(String string) {
        this.tagWidth = string;
    }

    public void addCompression(String string) {
        this.tagComp = string;
    }

    public void addBitsPerPixel(String string) {
        this.tagBPP = string;
    }

    public void addNumberOfColorComponents(String string) {
        this.tagNumCC = string;
    }

    public void addTag(int n, String string) {
        this.tags.put(new Integer(n), string);
    }

    public void addDecoder(String string, String string2) {
        this.decoder.put(string, string2);
    }

    public Hashtable getTags() {
        return this.exif;
    }

    protected void processExifDir(int n, int n2) {
        int n3 = this.data.get16u(n);
        block16: for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            int n6;
            int n7;
            block27: {
                block26: {
                    n7 = n + 2 + 12 * i;
                    n6 = this.data.get16u(n7);
                    n5 = this.data.get16u(n7 + 2);
                    n4 = this.data.get32u(n7 + 4);
                    if (n5 < 0) break block26;
                    if (n5 <= 12) break block27;
                }
                System.err.println("Bad number of formats in EXIF dir: " + n5);
                return;
            }
            int n8 = n4 * ExifData.bytesPerFormat[n5];
            int n9 = n7 + 8;
            if (n8 > 4) {
                int n10 = this.data.get32u(n7 + 8);
                n9 = n2 + n10;
            }
            Integer n11 = new Integer(n6);
            if (n6 == 34665 || n6 == 40965) {
                int n12 = this.data.get32u(n9);
                this.processExifDir(n2 + n12, n2);
                continue;
            }
            String string = "BugBugBug";
            boolean bl = false;
            if (this.tags.containsKey(n11)) {
                string = (String)this.tags.get(n11);
                bl = true;
            } else {
                string = ":unknown0x" + Integer.toHexString(n11);
            }
            if (this.decoder.containsKey(string)) {
                String string2 = (String)this.decoder.get(string);
                TagDecoder tagDecoder = null;
                try {
                    tagDecoder = (TagDecoder)Class.forName(string2).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Class not found: " + string2);
                }
                catch (InstantiationException instantiationException) {
                    System.err.println("Failed to instantiate " + string2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("Illegal access instantiating " + string2);
                }
                catch (ClassCastException classCastException) {
                    System.err.println("Class " + string2 + " is not a TagDecoder");
                }
                if (tagDecoder == null) continue;
                tagDecoder.decode(this.exif, this.data, n5, n9, n8);
                continue;
            }
            switch (n5) {
                case 7: {
                    this.assignUndefined(string, n9, n8);
                    continue block16;
                }
                case 2: {
                    this.assignString(string, n9, n8);
                    continue block16;
                }
                case 6: {
                    this.assignSByte(string, n9);
                    continue block16;
                }
                case 1: {
                    this.assignByte(string, n9);
                    continue block16;
                }
                case 3: {
                    this.assignUShort(string, n9);
                    continue block16;
                }
                case 8: {
                    this.assignSShort(string, n9);
                    continue block16;
                }
                case 4: {
                    this.assignULong(string, n9);
                    continue block16;
                }
                case 9: {
                    this.assignSLong(string, n9);
                    continue block16;
                }
                case 5: 
                case 10: {
                    this.assignRational(string, n9);
                    continue block16;
                }
            }
        }
    }

    protected void assignUndefined(String string, int n, int n2) {
        String string2 = this.data.getUndefined(n, n2);
        if (!"".equals(string2)) {
            this.exif.put(string, string2);
        }
    }

    protected void assignString(String string, int n, int n2) {
        String string2 = this.data.getString(n, n2);
        if (!"".equals(string2)) {
            this.exif.put(string, string2);
        }
    }

    protected void assignSByte(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(6, n);
        this.exif.put(string, "" + n2);
    }

    protected void assignByte(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(1, n);
        this.exif.put(string, "" + n2);
    }

    protected void assignUShort(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(3, n);
        this.exif.put(string, "" + n2);
    }

    protected void assignSShort(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(8, n);
        this.exif.put(string, "" + n2);
    }

    protected void assignULong(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(4, n);
        this.exif.put(string, "" + n2);
    }

    protected void assignSLong(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(9, n);
        this.exif.put(string, "" + n2);
    }

    protected void assignRational(String string, int n) {
        int n2 = this.data.get32s(n);
        int n3 = this.data.get32s(n + 4);
        String string2 = "";
        if (n2 % 10 == 0 && n3 % 10 == 0) {
            n2 /= 10;
            n3 /= 10;
        }
        if (n2 % 5 == 0 && n3 % 5 == 0) {
            n2 /= 5;
            n3 /= 5;
        }
        if (n2 % 3 == 0 && n3 % 3 == 0) {
            n2 /= 3;
            n3 /= 3;
        }
        if (n2 % 2 == 0 && n3 % 2 == 0) {
            n2 /= 2;
            n3 /= 2;
        }
        string2 = n3 == 0 ? "0" : (n3 == 1 ? "" + n2 : "" + n2 + "/" + n3);
        this.exif.put(string, "" + string2);
    }
}

