/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.jigsaw.ssi.Segment;
import org.w3c.tools.resources.upgrade.Attribute;
import org.w3c.util.CountOutputStream;

class SegmentArrayAttribute
extends Attribute {
    public boolean checkValue(Object object) {
        return object instanceof Segment[] || object == null;
    }

    public final int getPickleLength(Object object) {
        CountOutputStream countOutputStream = new CountOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(countOutputStream);
        Segment[] segmentArray = (Segment[])object;
        try {
            this.pickle(dataOutputStream, segmentArray);
            dataOutputStream.close();
            return countOutputStream.getCount();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IO erred in CountOutputStream.");
        }
    }

    public void pickle(DataOutputStream dataOutputStream, Object object) throws IOException {
        Segment[] segmentArray = (Segment[])object;
        dataOutputStream.writeInt(segmentArray.length);
        for (int i = 0; i < segmentArray.length; ++i) {
            segmentArray[i].pickle(dataOutputStream);
        }
    }

    public Object unpickle(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        Segment[] segmentArray = new Segment[n];
        for (int i = 0; i < n; ++i) {
            segmentArray[i] = Segment.unpickle(dataInputStream);
        }
        return segmentArray;
    }

    public SegmentArrayAttribute(String string, Segment[] segmentArray, Integer n) {
        super(string, segmentArray, n);
        this.type = "[Lorg.w3c.jigsaw.ssi.Segment;";
    }

    public String stringify(Object object) {
        Segment[] segmentArray = (Segment[])object;
        StringBuffer stringBuffer = new StringBuffer(160);
        stringBuffer.append('[');
        for (int i = 0; i < segmentArray.length; ++i) {
            stringBuffer.append(segmentArray[i].toString());
            stringBuffer.append(' ');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

