/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.resources.upgrade.Attribute;

public class StringArrayAttribute
extends Attribute {
    public String stringify(Object object) {
        if (object == null || !(object instanceof String[])) {
            return null;
        }
        String[] stringArray = (String[])object;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public boolean checkValue(Object object) {
        return object instanceof String[];
    }

    public int getPickleLength(Object object) {
        String[] stringArray = (String[])object;
        int n = 4;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n2 = string.length();
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                char c = string.charAt(j);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++n3;
                    continue;
                }
                if (c > '\u07ff') {
                    n3 += 3;
                    continue;
                }
                n3 += 2;
            }
            n += n3 + 2;
        }
        return n;
    }

    public void pickle(DataOutputStream dataOutputStream, Object object) throws IOException {
        String[] stringArray = (String[])object;
        dataOutputStream.writeInt(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            dataOutputStream.writeUTF(stringArray[i]);
        }
    }

    public Object unpickle(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        return stringArray;
    }

    public StringArrayAttribute(String string, String[] stringArray, Integer n) {
        super(string, stringArray, n);
        this.type = "java.lang.String[]";
    }
}

