/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.icp;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.www.protocol.http.icp.ICPMessage;
import org.w3c.www.protocol.http.icp.ICPProtocolException;

class ICPReply
extends ICPMessage {
    protected int getByteArrayLength() {
        return super.getByteArrayLength() + (this.url == null ? 0 : this.url.toExternalForm().length()) + 1;
    }

    protected int toByteArray(byte[] byArray) {
        int n = super.getByteArrayLength();
        String string = this.url == null ? null : this.url.toExternalForm();
        int n2 = string == null ? 0 : string.length();
        super.toByteArray(byArray);
        if (n2 > 0) {
            string.getBytes(0, n2, byArray, n);
        }
        byArray[n + n2] = 0;
        return n + n2 + 1;
    }

    protected int parse(byte[] byArray, int n, int n2) throws ICPProtocolException {
        for (int i = n = super.parse(byArray, n, n2); i < n2; ++i) {
            if (byArray[i] != 0) continue;
            if (i - n < 1) {
                return i;
            }
            String string = new String(byArray, 0, n, i - n);
            try {
                this.url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ICPProtocolException("Invalid URL:" + string);
            }
            return i;
        }
        throw new ICPProtocolException("Invalid URL encoding");
    }

    public final boolean isHit() {
        return this.opcode == 2;
    }

    ICPReply(InetAddress inetAddress, int n, int n2, int n3, byte[] byArray, int n4, int n5) throws ICPProtocolException {
        this.addr = inetAddress;
        this.port = n;
        this.opcode = n2;
        this.version = n3;
        this.parse(byArray, n4, n5);
    }

    ICPReply(int n, int n2) {
        this.id = n;
        this.opcode = n2;
    }
}

