/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons;

import com.phloc.commons.SystemProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class GlobalDebug {
    public static final boolean DEFAULT_TRACE_MODE = false;
    public static final boolean DEFAULT_DEBUG_MODE = false;
    public static final boolean DEFAULT_PRODUCTION_MODE = false;
    private static final AtomicBoolean s_aTraceMode = new AtomicBoolean(false);
    private static final AtomicBoolean s_aDebugMode = new AtomicBoolean(false);
    private static final AtomicBoolean s_aProductionMode = new AtomicBoolean(false);

    public void setTraceMode(boolean bTraceMode) {
        GlobalDebug.setTraceModeDirect(bTraceMode);
    }

    public void setDebugMode(boolean bDebugMode) {
        GlobalDebug.setDebugModeDirect(bDebugMode);
    }

    public void setProductionMode(boolean bProductionMode) {
        GlobalDebug.setProductionModeDirect(bProductionMode);
    }

    public static void setTraceModeDirect(boolean bTraceMode) {
        s_aTraceMode.set(bTraceMode);
        if (bTraceMode) {
            GlobalDebug.setDebugModeDirect(true);
        }
    }

    public static void setDebugModeDirect(boolean bDebugMode) {
        s_aDebugMode.set(bDebugMode);
        SystemProperties.setPropertyValue("jaxp.debug", Boolean.toString(bDebugMode));
        SystemProperties.setPropertyValue("javax.activation.debug", Boolean.toString(bDebugMode));
        if (!bDebugMode) {
            GlobalDebug.setTraceModeDirect(false);
        }
    }

    public static void setProductionModeDirect(boolean bProductionMode) {
        s_aProductionMode.set(bProductionMode);
        if (bProductionMode) {
            GlobalDebug.setDebugModeDirect(false);
        }
    }

    public static boolean isTraceMode() {
        return s_aTraceMode.get();
    }

    public static boolean isDebugMode() {
        return s_aDebugMode.get();
    }

    public static boolean isProductionMode() {
        return s_aProductionMode.get();
    }
}

