/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.base64;

import com.phloc.commons.base64.Base64;
import com.phloc.commons.charset.CharsetManager;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Base64Helper {
    private static final Base64Helper s_aInstance = new Base64Helper();

    private Base64Helper() {
    }

    @Nullable
    public static byte[] safeDecode(@Nonnull String sEncoded) {
        try {
            return Base64.decode(sEncoded);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static byte[] safeDecode(@Nonnull byte[] aEncodedBytes) {
        try {
            return Base64.decode(aEncodedBytes);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static String safeDecodeAsString(@Nonnull String sEncoded, @Nonnull String sCharset) {
        try {
            return CharsetManager.getAsString(Base64.decode(sEncoded), sCharset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static String safeDecodeAsString(@Nonnull String sEncoded, @Nonnull Charset aCharset) {
        try {
            return CharsetManager.getAsString(Base64.decode(sEncoded), aCharset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static String safeDecodeAsString(@Nonnull byte[] aEncodedBytes, @Nonnull String sCharset) {
        try {
            return CharsetManager.getAsString(Base64.decode(aEncodedBytes), sCharset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static String safeDecodeAsString(@Nonnull byte[] aEncodedBytes, @Nonnull Charset aCharset) {
        try {
            return CharsetManager.getAsString(Base64.decode(aEncodedBytes), aCharset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static String safeEncode(@Nonnull String s, @Nonnull String sCharset) {
        return Base64.encodeBytes(CharsetManager.getAsBytes(s, sCharset));
    }

    @Nullable
    public static String safeEncode(@Nonnull String s, @Nonnull Charset aCharset) {
        return Base64.encodeBytes(CharsetManager.getAsBytes(s, aCharset));
    }
}

