/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.changelog;

import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.changelog.AbstractChangeLogEntry;
import com.phloc.commons.changelog.ChangeLog;
import com.phloc.commons.changelog.EChangeLogAction;
import com.phloc.commons.changelog.EChangeLogCategory;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.text.IMultiLingualText;
import com.phloc.commons.text.IReadonlyMultiLingualText;
import com.phloc.commons.text.impl.MultiLingualText;
import com.phloc.commons.text.impl.ReadonlyMultiLingualText;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ChangeLogEntry
extends AbstractChangeLogEntry {
    private final ChangeLog m_aChangeLog;
    private final EChangeLogAction m_eAction;
    private final EChangeLogCategory m_eCategory;
    private final boolean m_bIsIncompatible;
    private final IMultiLingualText m_aTexts = new MultiLingualText();
    private final List<String> m_aIssues = new ArrayList<String>();

    public ChangeLogEntry(@Nonnull ChangeLog aChangeLog, @Nonnull Date aDate, @Nonnull EChangeLogAction eAction, @Nonnull EChangeLogCategory eCategory, boolean bIsIncompatible) {
        super(aDate);
        if (aChangeLog == null) {
            throw new NullPointerException("changeLog");
        }
        if (aDate == null) {
            throw new NullPointerException("date");
        }
        if (eAction == null) {
            throw new NullPointerException("action");
        }
        if (eCategory == null) {
            throw new NullPointerException("category");
        }
        this.m_aChangeLog = aChangeLog;
        this.m_eAction = eAction;
        this.m_eCategory = eCategory;
        this.m_bIsIncompatible = bIsIncompatible;
    }

    @Nonnull
    public ChangeLog getChangeLog() {
        return this.m_aChangeLog;
    }

    @Nonnull
    public EChangeLogAction getAction() {
        return this.m_eAction;
    }

    @Nonnull
    public EChangeLogCategory getCategory() {
        return this.m_eCategory;
    }

    public boolean isIncompatible() {
        return this.m_bIsIncompatible;
    }

    @Nonnull
    EChange setText(@Nonnull IReadonlyMultiLingualText aMLT) {
        if (aMLT == null) {
            throw new NullPointerException("MLT");
        }
        return this.m_aTexts.assignFrom(aMLT);
    }

    @Nonnull
    public EChange setText(@Nonnull Locale aContentLocale, @Nullable String sText) {
        String sRealText = StringHelper.trim(sText);
        if (StringHelper.hasNoText(sRealText)) {
            return EChange.UNCHANGED;
        }
        return this.m_aTexts.setText(aContentLocale, sRealText);
    }

    @Nonnull
    @ReturnsMutableCopy
    public IReadonlyMultiLingualText getAllTexts() {
        return new ReadonlyMultiLingualText(this.m_aTexts);
    }

    @Nullable
    public String getText(Locale aContentLocale) {
        return this.m_aTexts.getTextWithLocaleFallback(aContentLocale);
    }

    @Nonnull
    public EChange addIssue(@Nullable String sIssue) {
        String sRealIssue = StringHelper.trim(sIssue);
        if (StringHelper.hasNoText(sRealIssue)) {
            return EChange.UNCHANGED;
        }
        this.m_aIssues.add(sRealIssue);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsImmutableObject
    public List<String> getAllIssues() {
        return ContainerHelper.makeUnmodifiable(this.m_aIssues);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChangeLogEntry rhs = (ChangeLogEntry)o;
        return this.m_aChangeLog.getComponent().equals(rhs.m_aChangeLog.getComponent()) && this.m_eAction.equals(rhs.m_eAction) && this.m_eCategory.equals(rhs.m_eCategory) && this.m_bIsIncompatible == rhs.m_bIsIncompatible && this.m_aTexts.equals(rhs.m_aTexts) && ((Object)this.m_aIssues).equals(rhs.m_aIssues);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aChangeLog.getComponent()).append((Enum)this.m_eAction)).append((Enum)this.m_eCategory)).append(this.m_bIsIncompatible).append(this.m_aTexts).append(this.m_aIssues)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("changelog", this.m_aChangeLog.getComponent()).append("action", this.m_eAction).append("category", this.m_eCategory).append("isIncompatible", this.m_bIsIncompatible).append("texts", this.m_aTexts).append("issues", this.m_aIssues).toString();
    }
}

