/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.IByteArrayDecoder;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import javax.annotation.Nullable;

public final class ASCII85Codec
implements IByteArrayDecoder {
    private static final int BIT1 = 8;
    private static final int BIT2 = 16;
    private static final int BIT3 = 24;
    private static final int ENCODED_MAX = 117;
    private static final int ENCODED_MIN = 33;
    private static final int EIGHTY_FIVE = 85;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] aEncodedBuffer) {
        if (aEncodedBuffer == null) {
            return null;
        }
        if (aEncodedBuffer.length < 4) {
            throw new IllegalArgumentException("Buffer too small: " + aEncodedBuffer.length);
        }
        NonBlockingByteArrayOutputStream aBAOS = new NonBlockingByteArrayOutputStream();
        try {
            byte nEncByte;
            int nEncodedCount = 0;
            byte[] aBuffer = new byte[5];
            int nIndex = 0;
            if (aEncodedBuffer[0] == 60 && aEncodedBuffer[1] == 126) {
                nIndex = 2;
            }
            while (nIndex < aEncodedBuffer.length && (nEncByte = aEncodedBuffer[nIndex]) != 126) {
                if (!Character.isWhitespace(nEncByte)) {
                    if (nEncByte == 122 && nEncodedCount == 0) {
                        aBAOS.write(0);
                        aBAOS.write(0);
                        aBAOS.write(0);
                        aBAOS.write(0);
                    } else {
                        if (nEncByte < 33 || nEncByte > 117) {
                            throw new DecoderException("Illegal character in ASCII85Decode: " + nEncByte);
                        }
                        aBuffer[nEncodedCount] = (byte)(nEncByte - 33);
                        if (++nEncodedCount == 5) {
                            nEncodedCount = 0;
                            int r = 0;
                            for (int j = 0; j < 5; ++j) {
                                r = r * 85 + aBuffer[j];
                            }
                            aBAOS.write((byte)(r >> 24));
                            aBAOS.write((byte)(r >> 16));
                            aBAOS.write((byte)(r >> 8));
                            aBAOS.write((byte)r);
                        }
                    }
                }
                ++nIndex;
            }
            int nRest = 0;
            switch (nEncodedCount) {
                case 1: {
                    throw new IllegalStateException("Unexpected end of ASCII85 encoded data!");
                }
                case 2: {
                    nRest = aBuffer[0] * 85 * 85 * 85 * 85 + aBuffer[1] * 85 * 85 * 85 + 614125 + 7225 + 85;
                    aBAOS.write((byte)(nRest >> 24));
                    break;
                }
                case 3: {
                    nRest = aBuffer[0] * 85 * 85 * 85 * 85 + aBuffer[1] * 85 * 85 * 85 + aBuffer[2] * 85 * 85 + 7225 + 85;
                    aBAOS.write((byte)(nRest >> 24));
                    aBAOS.write((byte)(nRest >> 16));
                    break;
                }
                case 4: {
                    nRest = aBuffer[0] * 85 * 85 * 85 * 85 + aBuffer[1] * 85 * 85 * 85 + aBuffer[2] * 85 * 85 + aBuffer[3] * 85 + 85;
                    aBAOS.write((byte)(nRest >> 24));
                    aBAOS.write((byte)(nRest >> 16));
                    aBAOS.write((byte)(nRest >> 8));
                    break;
                }
            }
            byte[] byArray = aBAOS.toByteArray();
            return byArray;
        }
        finally {
            StreamUtils.close(aBAOS);
        }
    }
}

