/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.EncoderException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLZWDictionary {
    protected static final Logger s_aLogger = LoggerFactory.getLogger(AbstractLZWDictionary.class);
    public static final int MAX_CODE = 4096;
    public static final int CODE_CLEARTABLE = 256;
    public static final int CODE_EOF = 257;
    protected byte[][] m_aTab;
    protected int m_nFreeCode;
    protected int m_nCodeBits;

    public void reset() {
        this.m_aTab = new byte[4096][];
        for (int i = 0; i < 256; ++i) {
            this.m_aTab[i] = new byte[]{(byte)i};
        }
        this.m_nFreeCode = 258;
        this.m_nCodeBits = 9;
    }

    public final void addString(@Nonnull byte[] aByteSeq, boolean bForEncode) {
        if (aByteSeq == null) {
            throw new NullPointerException("entry");
        }
        if (this.m_nFreeCode == this.m_aTab.length) {
            throw bForEncode ? new EncoderException("LZW encode table overflow") : new DecoderException("LZW decode table overflow");
        }
        this.m_aTab[this.m_nFreeCode] = aByteSeq;
        ++this.m_nFreeCode;
        if (this.m_nFreeCode == (bForEncode ? 512 : 511)) {
            this.m_nCodeBits = 10;
        } else if (this.m_nFreeCode == (bForEncode ? 1024 : 1023)) {
            this.m_nCodeBits = 11;
        } else if (this.m_nFreeCode == (bForEncode ? 2048 : 2047)) {
            this.m_nCodeBits = 12;
        }
    }

    @Nonnegative
    public final int getNextFreeCode() {
        return this.m_nFreeCode;
    }
}

