/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SingleMapEntry<KEYTYPE, VALUETYPE>
implements Map.Entry<KEYTYPE, VALUETYPE> {
    private final KEYTYPE m_aKey;
    private VALUETYPE m_aValue;

    public SingleMapEntry(@Nullable KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        this.m_aKey = aKey;
        this.m_aValue = aValue;
    }

    @Override
    @Nullable
    public KEYTYPE getKey() {
        return this.m_aKey;
    }

    @Override
    @Nullable
    public VALUETYPE getValue() {
        return this.m_aValue;
    }

    @Override
    @Nullable
    public VALUETYPE setValue(@Nullable VALUETYPE aValue) {
        VALUETYPE aOldValue = this.m_aValue;
        this.m_aValue = aValue;
        return aOldValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleMapEntry)) {
            return false;
        }
        SingleMapEntry rhs = (SingleMapEntry)o;
        return EqualsUtils.equals(this.m_aKey, rhs.m_aKey) && EqualsUtils.equals(this.m_aValue, rhs.m_aValue);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aKey).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("key", this.m_aKey).append("value", this.m_aValue).toString();
    }
}

