/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.format;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.format.IFormattedObject;
import com.phloc.commons.format.IFormatter;
import com.phloc.commons.format.IFormatterProvider;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormattedObject
implements IFormattedObject {
    private final Object m_aValue;
    private final IFormatter m_aFormatter;

    public FormattedObject(@Nullable Object aValue, @Nullable IFormatter aFormatter) {
        this.m_aValue = aValue;
        this.m_aFormatter = aFormatter;
    }

    public FormattedObject(@Nullable Object aValue, @Nonnull IFormatterProvider aFormatterProvider) {
        if (aFormatterProvider == null) {
            throw new NullPointerException("formatterProvider");
        }
        this.m_aValue = aValue;
        this.m_aFormatter = aFormatterProvider.getFormatter();
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.m_aValue;
    }

    @Override
    @Nonnull
    public IFormatter getFormatter() {
        return this.m_aFormatter;
    }

    @Override
    @Nullable
    public String getAsString() {
        return this.m_aFormatter != null ? this.m_aFormatter.getFormattedValue(this.m_aValue) : String.valueOf(this.m_aValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        FormattedObject rhs = (FormattedObject)o;
        return EqualsUtils.equals(this.m_aValue, rhs.m_aValue) && EqualsUtils.equals(this.m_aFormatter, rhs.m_aFormatter);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValue).append(this.m_aFormatter).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_aValue).appendIfNotNull("formatter", this.m_aFormatter).toString();
    }
}

