/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.gfx;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.math.IHasWidthAndHeight;
import com.phloc.commons.math.MathHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ScalableSize
implements IHasWidthAndHeight,
Serializable {
    private final int m_nWidth;
    private final int m_nHeight;

    public ScalableSize(@Nonnull IHasWidthAndHeight aObj) {
        this(aObj.getWidth(), aObj.getHeight());
    }

    public ScalableSize(@Nonnegative int nWidth, @Nonnegative int nHeight) {
        if (nWidth < 0) {
            throw new IllegalArgumentException("Width may not be < 0: " + nWidth);
        }
        if (nHeight < 0) {
            throw new IllegalArgumentException("Height may not be < 0: " + nHeight);
        }
        this.m_nWidth = nWidth;
        this.m_nHeight = nHeight;
    }

    @Override
    @Nonnegative
    public int getWidth() {
        return this.m_nWidth;
    }

    @Override
    @Nonnegative
    public int getHeight() {
        return this.m_nHeight;
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getBestMatchingSize(@Nonnegative int nMaxWidth, @Nonnegative int nMaxHeight) {
        double dRelHeight;
        if (nMaxWidth < 1) {
            throw new IllegalArgumentException("Passed width value is not allowed: " + nMaxWidth);
        }
        if (nMaxHeight < 1) {
            throw new IllegalArgumentException("Passed height value is not allowed: " + nMaxHeight);
        }
        double dRelWidth = MathHelper.getDividedDouble(this.m_nWidth, nMaxWidth);
        if (dRelWidth > (dRelHeight = MathHelper.getDividedDouble(this.m_nHeight, nMaxHeight))) {
            if (this.m_nWidth > nMaxWidth) {
                return new ScalableSize(nMaxWidth, (int)((double)this.m_nHeight / dRelWidth));
            }
        } else if (this.m_nHeight > nMaxHeight) {
            return new ScalableSize((int)((double)this.m_nWidth / dRelHeight), nMaxHeight);
        }
        return this;
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getScaledToWidth(@Nonnegative int nNewWidth) {
        if (nNewWidth < 1) {
            throw new IllegalArgumentException("Passed width value is not allowed: " + nNewWidth);
        }
        if (this.m_nWidth == nNewWidth) {
            return this;
        }
        double dMultFactory = MathHelper.getDividedDouble(nNewWidth, this.m_nWidth);
        return new ScalableSize(nNewWidth, (int)((double)this.m_nHeight * dMultFactory));
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getScaledToHeight(@Nonnegative int nNewHeight) {
        if (nNewHeight < 1) {
            throw new IllegalArgumentException("Passed height value is not allowed: " + nNewHeight);
        }
        if (this.m_nHeight == nNewHeight) {
            return this;
        }
        double dMultFactory = MathHelper.getDividedDouble(nNewHeight, this.m_nHeight);
        return new ScalableSize((int)((double)this.m_nWidth * dMultFactory), nNewHeight);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScalableSize)) {
            return false;
        }
        ScalableSize rhs = (ScalableSize)o;
        return this.m_nWidth == rhs.m_nWidth && this.m_nHeight == rhs.m_nHeight;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nWidth).append(this.m_nHeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("width", this.m_nWidth).append("height", this.m_nHeight).toString();
    }
}

