/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.graph.impl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.idfactory.GlobalIDFactory;
import com.phloc.commons.idfactory.IIDFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class GraphObjectIDFactory {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static IIDFactory<String> s_aIDFactory;
    private static final GraphObjectIDFactory s_aInstance;

    private GraphObjectIDFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IIDFactory<String> getIDFactory() {
        s_aRWLock.readLock().lock();
        try {
            IIDFactory<String> iIDFactory = s_aIDFactory;
            return iIDFactory;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIDFactory(@Nullable IIDFactory<String> aIDFactory) {
        s_aRWLock.writeLock().lock();
        try {
            s_aIDFactory = aIDFactory;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Nonempty
    public static String createNewGraphObjectID() {
        s_aRWLock.readLock().lock();
        try {
            String string = s_aIDFactory != null ? s_aIDFactory.getNewID() : GlobalIDFactory.getNewStringID();
            return string;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        s_aInstance = new GraphObjectIDFactory();
    }
}

