/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.hash;

import com.phloc.commons.hash.HashCodeImplementationRegistry;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HashCodeCalculator {
    public static final int MULTIPLIER = 31;
    public static final int HASHCODE_NULL = 129;
    private static final HashCodeCalculator s_aInstance = new HashCodeCalculator();

    private HashCodeCalculator() {
    }

    public static int append(int nPrevHashCode, boolean x) {
        return HashCodeCalculator.append(nPrevHashCode, x ? 1231 : 1237);
    }

    public static int append(int nPrevHashCode, byte x) {
        return HashCodeCalculator.append(nPrevHashCode, (int)x);
    }

    public static int append(int nPrevHashCode, char x) {
        return HashCodeCalculator.append(nPrevHashCode, (int)x);
    }

    public static int append(int nPrevHashCode, double x) {
        return HashCodeCalculator.append(nPrevHashCode, x == 0.0 ? 0L : Double.doubleToLongBits(x));
    }

    public static int append(int nPrevHashCode, float x) {
        return HashCodeCalculator.append(nPrevHashCode, x == 0.0f ? 0 : Float.floatToIntBits(x));
    }

    public static int append(int nPrevHashCode, int x) {
        return nPrevHashCode * 31 + x;
    }

    public static int append(int nPrevHashCode, long x) {
        int nTemp = HashCodeCalculator.append(nPrevHashCode, (int)(x >>> 32));
        return HashCodeCalculator.append(nTemp, (int)(x & 0xFFFFFFFFFFFFFFFFL));
    }

    public static int append(int nPrevHashCode, short x) {
        return HashCodeCalculator.append(nPrevHashCode, (int)x);
    }

    public static int append(int nPrevHashCode, @Nullable Object x) {
        return HashCodeCalculator.append(nPrevHashCode, HashCodeImplementationRegistry.getHashCode(x));
    }
}

