/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.idfactory;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.idfactory.ILongIDFactory;
import com.phloc.commons.string.ToStringGenerator;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MemoryLongIDFactory
implements ILongIDFactory {
    @Nonnegative
    public static final long DEFAULT_START_ID = 10000L;
    @Nonnegative
    private final AtomicLong m_aID;

    public MemoryLongIDFactory() {
        this(10000L);
    }

    public MemoryLongIDFactory(@Nonnegative long nStartID) {
        if (nStartID < 0L) {
            throw new IllegalArgumentException("Passed start ID is invalid: " + nStartID);
        }
        this.m_aID = new AtomicLong(nStartID);
    }

    @Override
    @Nonnegative
    public long getNewID() {
        return this.m_aID.getAndIncrement();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoryLongIDFactory)) {
            return false;
        }
        MemoryLongIDFactory rhs = (MemoryLongIDFactory)o;
        return this.m_aID.get() == rhs.m_aID.get();
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aID.get()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_aID).toString();
    }
}

