/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.misc;

import com.phloc.commons.CGlobal;
import com.phloc.commons.lang.DecimalFormatSymbolsFactory;
import com.phloc.commons.string.ToStringGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SizeHelper {
    public static final String B_SUFFIX = "B";
    public static final String KB_SUFFIX = "KB";
    public static final String MB_SUFFIX = "MB";
    public static final String GB_SUFFIX = "GB";
    public static final String TB_SUFFIX = "TB";
    public static final String PB_SUFFIX = "PB";
    private final DecimalFormat m_aDF0;
    private final DecimalFormat m_aDF1;
    private final DecimalFormat m_aDF2;
    private final DecimalFormatSymbols m_aDFS;

    public SizeHelper(@Nonnull Locale aDisplayLocale) {
        if (aDisplayLocale == null) {
            throw new NullPointerException("displayLocale");
        }
        this.m_aDFS = DecimalFormatSymbolsFactory.getInstance(aDisplayLocale);
        this.m_aDF0 = new DecimalFormat("0", this.m_aDFS);
        this.m_aDF1 = new DecimalFormat("0.0", this.m_aDFS);
        this.m_aDF2 = new DecimalFormat("0.00", this.m_aDFS);
    }

    @Nonnull
    private String _format(long nSize) {
        return this.m_aDF0.format(nSize);
    }

    @Nonnull
    private String _format(double dSize, @Nonnegative int nDecimals) {
        if (nDecimals < 0) {
            throw new IllegalArgumentException("Number of decimals must be >= 0!");
        }
        if (nDecimals == 0) {
            return this._format((long)dSize);
        }
        if (nDecimals == 1) {
            return this.m_aDF1.format(dSize);
        }
        if (nDecimals == 2) {
            return this.m_aDF2.format(dSize);
        }
        StringBuilder aFormat = new StringBuilder("0.000");
        for (int i = 3; i < nDecimals; ++i) {
            aFormat.append('0');
        }
        return new DecimalFormat(aFormat.toString(), this.m_aDFS).format(dSize);
    }

    @Nonnull
    public String getAsKB(long nSize) {
        return this._format(nSize / 1024L) + KB_SUFFIX;
    }

    @Nonnull
    public String getAsKB(long nSize, @Nonnegative int nDecimals) {
        return this._format((double)nSize / 1024.0, nDecimals) + KB_SUFFIX;
    }

    @Nonnull
    public String getAsMB(long nSize) {
        return this._format(nSize / 0x100000L) + MB_SUFFIX;
    }

    @Nonnull
    public String getAsMB(long nSize, @Nonnegative int nDecimals) {
        return this._format((double)nSize / 1048576.0, nDecimals) + MB_SUFFIX;
    }

    @Nonnull
    public String getAsGB(long nSize) {
        return this._format(nSize / 0x40000000L) + GB_SUFFIX;
    }

    @Nonnull
    public String getAsGB(long nSize, @Nonnegative int nDecimals) {
        return this._format((double)nSize / 1.073741824E9, nDecimals) + GB_SUFFIX;
    }

    @Nonnull
    public String getAsTB(long nSize) {
        return this._format(nSize / 0x10000000000L) + TB_SUFFIX;
    }

    @Nonnull
    public String getAsTB(long nSize, @Nonnegative int nDecimals) {
        return this._format((double)nSize / 1.099511627776E12, nDecimals) + TB_SUFFIX;
    }

    @Nonnull
    public String getAsPB(long nSize) {
        return this._format(nSize / 0x4000000000000L) + PB_SUFFIX;
    }

    @Nonnull
    public String getAsPB(long nSize, @Nonnegative int nDecimals) {
        return this._format((double)nSize / 1.125899906842624E15, nDecimals) + PB_SUFFIX;
    }

    private static void _checkConvertibility(@Nonnull BigInteger aSize) {
        if (aSize.compareTo(CGlobal.BIGINT_MAX_LONG) > 0) {
            throw new IllegalArgumentException("The passed BigInteger is too large to be converted into a long value: " + aSize.toString());
        }
        if (aSize.compareTo(CGlobal.BIGINT_MIN_LONG) < 0) {
            throw new IllegalArgumentException("The passed BigInteger is too small to be converted into a long value: " + aSize.toString());
        }
    }

    @Nonnull
    public String getAsMatching(@Nonnull BigInteger aSize) {
        SizeHelper._checkConvertibility(aSize);
        return this.getAsMatching(aSize.longValue());
    }

    @Nonnull
    public String getAsMatching(@Nonnull BigInteger aSize, @Nonnegative int nDecimals) {
        SizeHelper._checkConvertibility(aSize);
        return this.getAsMatching(aSize.longValue(), nDecimals);
    }

    private static void _checkConvertibility(@Nonnull BigDecimal aSize) {
        if (aSize.compareTo(CGlobal.BIGDEC_MAX_LONG) > 0) {
            throw new IllegalArgumentException("The passed BigDecimal is too large to be converted into a long value: " + aSize.toString());
        }
        if (aSize.compareTo(CGlobal.BIGDEC_MIN_LONG) < 0) {
            throw new IllegalArgumentException("The passed BigDecimal is too small to be converted into a long value: " + aSize.toString());
        }
    }

    @Nonnull
    public String getAsMatching(@Nonnull BigDecimal aSize) {
        SizeHelper._checkConvertibility(aSize);
        return this.getAsMatching(aSize.longValue());
    }

    @Nonnull
    public String getAsMatching(@Nonnull BigDecimal aSize, @Nonnegative int nDecimals) {
        SizeHelper._checkConvertibility(aSize);
        return this.getAsMatching(aSize.longValue(), nDecimals);
    }

    @Nonnull
    public String getAsMatching(long nSize) {
        if (nSize >= 0x4000000000000L) {
            return this.getAsPB(nSize);
        }
        if (nSize >= 0x10000000000L) {
            return this.getAsTB(nSize);
        }
        if (nSize >= 0x40000000L) {
            return this.getAsGB(nSize);
        }
        if (nSize >= 0x100000L) {
            return this.getAsMB(nSize);
        }
        if (nSize >= 1024L) {
            return this.getAsKB(nSize);
        }
        return this._format(nSize) + B_SUFFIX;
    }

    @Nonnull
    public String getAsMatching(long nSize, @Nonnegative int nDecimals) {
        if (nSize >= 0x4000000000000L) {
            return this.getAsPB(nSize, nDecimals);
        }
        if (nSize >= 0x10000000000L) {
            return this.getAsTB(nSize, nDecimals);
        }
        if (nSize >= 0x40000000L) {
            return this.getAsGB(nSize, nDecimals);
        }
        if (nSize >= 0x100000L) {
            return this.getAsMB(nSize, nDecimals);
        }
        if (nSize >= 1024L) {
            return this.getAsKB(nSize, nDecimals);
        }
        return this._format(nSize, nDecimals) + B_SUFFIX;
    }

    public String toString() {
        return new ToStringGenerator(this).append("dfs", this.m_aDFS).toString();
    }

    @Nonnull
    public static SizeHelper getSizeHelperOfLocale(@Nonnull Locale aDisplayLocale) {
        return new SizeHelper(aDisplayLocale);
    }
}

