/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.IHasSize;
import com.phloc.commons.IHasStringRepresentation;
import com.phloc.commons.annotations.DevelopersNote;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.annotations.ReturnsMutableObject;
import java.io.Serializable;
import java.io.Writer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NonBlockingStringWriter
extends Writer
implements IHasStringRepresentation,
IHasSize,
Serializable {
    private final StringBuilder m_aSB;

    public NonBlockingStringWriter() {
        this.m_aSB = new StringBuilder();
        this.lock = this.m_aSB;
    }

    public NonBlockingStringWriter(@Nonnegative int nInitialSize) {
        if (nInitialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.m_aSB = new StringBuilder(nInitialSize);
        this.lock = this.m_aSB;
    }

    @Override
    public void write(int c) {
        this.m_aSB.append((char)c);
    }

    @Override
    public void write(@Nonnull char[] aBuf, @Nonnegative int nOfs, @Nonnegative int nLen) {
        if (nOfs < 0 || nLen < 0 || nOfs + nLen > aBuf.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + aBuf.length);
        }
        if (nLen > 0) {
            this.m_aSB.append(aBuf, nOfs, nLen);
        }
    }

    @Override
    public void write(@Nullable String sStr) {
        this.m_aSB.append(sStr);
    }

    @Override
    public void write(@Nonnull String sStr, int nOfs, int nLen) {
        this.m_aSB.append(sStr.substring(nOfs, nOfs + nLen));
    }

    @Override
    public NonBlockingStringWriter append(CharSequence aCS) {
        if (aCS == null) {
            this.write("null");
        } else {
            this.write(((Object)aCS).toString());
        }
        return this;
    }

    @Override
    public NonBlockingStringWriter append(CharSequence aCS, int nStart, int nEnd) {
        CharSequence cs = aCS == null ? "null" : aCS;
        this.write(((Object)cs.subSequence(nStart, nEnd)).toString());
        return this;
    }

    @Override
    public NonBlockingStringWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Nonnull
    @ReturnsMutableObject(reason="design")
    public StringBuilder directGetStringBuilder() {
        return this.m_aSB;
    }

    @Nonnull
    @ReturnsMutableCopy
    public char[] getAsCharArray() {
        int nChars = this.m_aSB.length();
        char[] ret = new char[nChars];
        this.m_aSB.getChars(0, nChars, ret, 0);
        return ret;
    }

    @Override
    @Nonnull
    public String getAsString() {
        return this.m_aSB.toString();
    }

    public void reset() {
        this.m_aSB.setLength(0);
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aSB.length();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aSB.length() == 0;
    }

    @Deprecated
    @DevelopersNote(value="Use getAsString as it is more explicit!")
    public String toString() {
        return this.getAsString();
    }
}

