/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.jaxb.validation;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.error.ResourceError;
import com.phloc.commons.error.ResourceLocation;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.serialize.XMLWriter;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@NotThreadSafe
public abstract class AbstractValidationEventHandler
implements ValidationEventHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractValidationEventHandler.class);
    private final ValidationEventHandler m_aWrappedHandler;

    public AbstractValidationEventHandler() {
        this(null);
    }

    public AbstractValidationEventHandler(@Nullable ValidationEventHandler aWrappedHandler) {
        this.m_aWrappedHandler = aWrappedHandler;
    }

    @Nullable
    public final ValidationEventHandler getWrappedHandler() {
        return this.m_aWrappedHandler;
    }

    @Nonnull
    @OverrideOnDemand
    protected EErrorLevel getErrorLevel(int nSeverity) {
        switch (nSeverity) {
            case 0: {
                return EErrorLevel.WARN;
            }
            case 1: {
                return EErrorLevel.ERROR;
            }
            case 2: {
                return EErrorLevel.FATAL_ERROR;
            }
        }
        s_aLogger.warn("Unknown JAXB validation severity: " + nSeverity + "; defaulting to error");
        return EErrorLevel.ERROR;
    }

    @Nullable
    private static String _getLocationResourceID(@Nullable ValidationEventLocator aLocator) {
        if (aLocator != null) {
            URL aURL = aLocator.getURL();
            if (aURL != null) {
                return aURL.toString();
            }
            Object aObj = aLocator.getObject();
            if (aObj != null) {
                return "obj: " + aObj.toString();
            }
            Node aNode = aLocator.getNode();
            if (aNode != null) {
                return XMLWriter.getXMLString(aNode);
            }
        }
        return null;
    }

    protected abstract void onEvent(@Nonnull IResourceError var1);

    @OverrideOnDemand
    protected boolean continueProcessing(@Nonnull EErrorLevel eErrorLevel) {
        return eErrorLevel.isLessSevereThan(EErrorLevel.FATAL_ERROR);
    }

    public final boolean handleEvent(@Nonnull ValidationEvent aEvent) {
        EErrorLevel eErrorLevel = this.getErrorLevel(aEvent.getSeverity());
        ValidationEventLocator aLocator = aEvent.getLocator();
        ResourceLocation aLocation = new ResourceLocation(AbstractValidationEventHandler._getLocationResourceID(aLocator), aLocator != null ? aLocator.getLineNumber() : -1, aLocator != null ? aLocator.getColumnNumber() : -1);
        String sMsg = aEvent.getMessage();
        if (sMsg == null) {
            if (aEvent.getLinkedException() != null) {
                sMsg = aEvent.getLinkedException().getMessage();
                if (sMsg == null) {
                    sMsg = "Exception";
                }
            } else {
                sMsg = "Validation event";
            }
        }
        this.onEvent(new ResourceError((IResourceLocation)aLocation, eErrorLevel, sMsg, aEvent.getLinkedException()));
        if (this.m_aWrappedHandler != null) {
            return this.m_aWrappedHandler.handleEvent(aEvent);
        }
        return this.continueProcessing(eErrorLevel);
    }

    public String toString() {
        return new ToStringGenerator(this).append("origHandler", this.m_aWrappedHandler).toString();
    }
}

