/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.jmx;

import com.phloc.commons.jmx.ObjectNameUtils;
import com.phloc.commons.state.ESuccess;
import java.lang.management.ManagementFactory;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JMXUtils {
    private static final Logger s_aLogger = LoggerFactory.getLogger(JMXUtils.class);
    private static final JMXUtils s_aInstance = new JMXUtils();

    private JMXUtils() {
    }

    @Nonnull
    public static ESuccess exposeMBean(@Nonnull Object aObject, @Nonnull ObjectName aObjectName) {
        if (aObject == null) {
            throw new NullPointerException("object");
        }
        if (aObjectName == null) {
            throw new NullPointerException("objectName");
        }
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(aObject, aObjectName);
            return ESuccess.SUCCESS;
        }
        catch (JMException ex) {
            s_aLogger.error("Error registering MBean with name " + aObjectName, (Throwable)ex);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static ESuccess exposeMBeanWithAutoName(@Nonnull Object aObj) {
        return JMXUtils.exposeMBean(aObj, ObjectNameUtils.createWithDefaultProperties(aObj));
    }

    @Nonnull
    public static ESuccess exposeMBeanWithAutoName(@Nonnull Object aObj, @Nonnull String sName) {
        return JMXUtils.exposeMBean(aObj, ObjectNameUtils.createWithDefaultProperties(aObj, sName));
    }
}

