/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CGStringHelper {
    private static final CGStringHelper s_aInstance = new CGStringHelper();

    private CGStringHelper() {
    }

    @Nonnull
    public static String getClassLocalName(@Nonnull Object aObject) {
        if (aObject == null) {
            throw new NullPointerException("object");
        }
        return CGStringHelper.getClassLocalName(aObject.getClass());
    }

    @Nonnull
    public static String getClassLocalName(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        return CGStringHelper.getClassLocalName(aClass.getName());
    }

    @Nonnull
    public static String getClassLocalName(@Nonnull String sClassName) {
        if (sClassName == null) {
            throw new NullPointerException("className");
        }
        int nIndex = sClassName.lastIndexOf(46);
        return nIndex == -1 ? sClassName : sClassName.substring(nIndex + 1);
    }

    @Nonnull
    public static String getClassPackageName(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        return CGStringHelper.getClassPackageName(aClass.getName());
    }

    @Nonnull
    public static String getClassPackageName(@Nonnull String sClassName) {
        if (sClassName == null) {
            throw new NullPointerException("className");
        }
        int nIndex = sClassName.lastIndexOf(46);
        return nIndex == -1 ? "" : sClassName.substring(0, nIndex);
    }

    @Nonnull
    public static String getSafeClassName(@Nullable Object aObject) {
        if (aObject instanceof Class) {
            return ((Class)aObject).getName();
        }
        if (aObject != null) {
            return aObject.getClass().getName();
        }
        return "null";
    }

    @Nonnull
    public static String getDirectoryFromPackage(@Nonnull Package aPackage) {
        if (aPackage == null) {
            throw new NullPointerException("package");
        }
        return CGStringHelper.getPathFromClass(aPackage.getName());
    }

    @Nonnull
    public static String getDirectoryFromPackage(@Nonnull String sPackage) {
        return CGStringHelper.getPathFromClass(sPackage);
    }

    @Nonnull
    public static String getPathFromClass(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        return CGStringHelper.getPathFromClass(aClass.getName());
    }

    @Nonnull
    public static String getPathFromClass(@Nonnull String sClassName) {
        if (sClassName == null) {
            throw new NullPointerException("className");
        }
        return sClassName.replace('.', '/');
    }

    @Nonnull
    public static String getClassFromPath(@Nonnull String sPath) {
        if (sPath == null) {
            throw new NullPointerException("path");
        }
        return sPath.replace('\\', '.').replace('/', '.');
    }

    @Nonnull
    @Nonempty
    public static String getObjectAddress(@Nullable Object aObject) {
        if (aObject == null) {
            return "0x00000000";
        }
        return "0x" + StringHelper.getHexStringLeadingZero(System.identityHashCode(aObject), 8);
    }
}

