/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.microdom.EMicroNodeType;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroDocumentType;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.MicroException;
import com.phloc.commons.microdom.impl.AbstractMicroNode;
import com.phloc.commons.microdom.impl.AbstractMicroNodeWithChildren;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroDocument
extends AbstractMicroNodeWithChildren
implements IMicroDocument {
    public MicroDocument() {
    }

    public MicroDocument(@Nullable IMicroDocumentType aDocType) {
        if (aDocType != null) {
            this.appendChild(aDocType);
        }
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.DOCUMENT;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    private static boolean _canBeAppendedToDocumentRoot(@Nonnull IMicroNode aNode) {
        return aNode.isDocumentType() || aNode.isProcessingInstruction() || aNode.isComment() || aNode.isElement();
    }

    @Override
    protected void onAppendChild(@Nonnull AbstractMicroNode aChildNode) {
        if (!MicroDocument._canBeAppendedToDocumentRoot(aChildNode)) {
            throw new MicroException("Cannot add nodes of type " + aChildNode + " to a document");
        }
        if (aChildNode.isElement() && this.directGetChildren() != null && !this.directGetChildren().isEmpty()) {
            for (IMicroNode aCurChild : this.directGetChildren()) {
                if (!aCurChild.isElement()) continue;
                throw new MicroException("A document can only have one document element! Already has " + aCurChild + " and wants to add " + aChildNode);
            }
        }
        super.onAppendChild(aChildNode);
    }

    @Override
    public boolean isStandalone() {
        if (this.getDocType() != null) {
            return false;
        }
        IMicroElement aDocElement = this.getDocumentElement();
        if (aDocElement != null && aDocElement.hasAttributes()) {
            for (Map.Entry<String, String> aEntry : aDocElement.getAttributes().entrySet()) {
                String sAttrName = aEntry.getKey();
                if (!sAttrName.startsWith("xmlns:") || !aEntry.getValue().equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                String sXSINamespacePrefix = sAttrName.substring("xmlns:".length());
                return aDocElement.getAttribute(sXSINamespacePrefix + ":schemaLocation") == null;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public IMicroDocumentType getDocType() {
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (!aChild.isDocumentType()) continue;
                return (IMicroDocumentType)aChild;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getDocumentElement() {
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (!aChild.isElement()) continue;
                return (IMicroElement)aChild;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public IMicroDocument getClone() {
        MicroDocument ret = new MicroDocument();
        if (this.hasChildren()) {
            for (IMicroNode aChildNode : this.getChildren()) {
                ret.appendChild((IMicroNode)aChildNode.getClone());
            }
        }
        return ret;
    }
}

