/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.reader;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IOutputStreamProvider;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.impl.MicroDocument;
import com.phloc.commons.microdom.serialize.MicroReader;
import com.phloc.commons.microdom.serialize.MicroWriter;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class XMLListHandler {
    public static final String ELEMENT_LIST = "list";
    public static final String ELEMENT_ITEM = "item";
    public static final String ATTR_VALUE = "value";
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLListHandler.class);
    private static final XMLListHandler s_aInstance = new XMLListHandler();

    private XMLListHandler() {
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readList(@Nonnull IInputStreamProvider aISP) {
        if (aISP == null) {
            throw new NullPointerException("ISP");
        }
        return XMLListHandler.readList(aISP.getInputStream());
    }

    @Nonnull
    public static ESuccess readList(@Nonnull IInputStreamProvider aISP, @Nonnull Collection<String> aTargetList) {
        if (aISP == null) {
            throw new NullPointerException("ISP");
        }
        return XMLListHandler.readList(aISP.getInputStream(), aTargetList);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readList(@Nonnull @WillClose InputStream aIS) {
        ArrayList<String> ret = new ArrayList<String>();
        if (XMLListHandler.readList(aIS, ret).isFailure()) {
            return null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess readList(@Nonnull @WillClose InputStream aIS, @Nonnull Collection<String> aTargetList) {
        if (aIS == null) {
            throw new NullPointerException("resource");
        }
        if (aTargetList == null) {
            throw new NullPointerException("targetList");
        }
        try {
            IMicroDocument aDoc = MicroReader.readMicroXML(aIS);
            if (aDoc != null) {
                XMLListHandler.readList(aDoc.getDocumentElement(), aTargetList);
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (Throwable t) {
            s_aLogger.warn("Failed to read list resource '" + aIS + "'", t);
        }
        finally {
            StreamUtils.close(aIS);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess readList(@Nonnull IMicroElement aParentElement, @Nonnull Collection<String> aTargetList) {
        if (aParentElement == null) {
            throw new NullPointerException("parentElement");
        }
        if (aTargetList == null) {
            throw new NullPointerException("targetList");
        }
        try {
            for (IMicroElement eItem : aParentElement.getChildElements(ELEMENT_ITEM)) {
                String sValue = eItem.getAttribute(ATTR_VALUE);
                if (sValue == null) {
                    s_aLogger.warn("Ignoring list item because value is null");
                    continue;
                }
                if (aTargetList.add(sValue)) continue;
                s_aLogger.warn("Ignoring list item '" + sValue + "' because value is already contained");
            }
            return ESuccess.SUCCESS;
        }
        catch (Throwable t) {
            s_aLogger.warn("Failed to read list document", t);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static IMicroDocument createListDocument(@Nonnull Collection<String> aCollection) {
        if (aCollection == null) {
            throw new NullPointerException("collection");
        }
        MicroDocument aDoc = new MicroDocument();
        IMicroElement eRoot = aDoc.appendElement(ELEMENT_LIST);
        for (String sItem : aCollection) {
            IMicroElement eItem = eRoot.appendElement(ELEMENT_ITEM);
            eItem.setAttribute(ATTR_VALUE, sItem);
        }
        return aDoc;
    }

    @Nonnull
    public static ESuccess writeList(@Nonnull Collection<String> aCollection, @Nonnull IOutputStreamProvider aOSP) {
        if (aOSP == null) {
            throw new NullPointerException("outputStreamProvider");
        }
        return XMLListHandler.writeList(aCollection, aOSP.getOutputStream(EAppend.DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeList(@Nonnull Collection<String> aCollection, @Nonnull @WillClose OutputStream aOS) {
        if (aCollection == null) {
            throw new NullPointerException("map");
        }
        if (aOS == null) {
            throw new NullPointerException("outputStream");
        }
        try {
            IMicroDocument aDoc = XMLListHandler.createListDocument(aCollection);
            ESuccess eSuccess = MicroWriter.writeToStream(aDoc, aOS, XMLWriterSettings.DEFAULT_XML_SETTINGS);
            return eSuccess;
        }
        finally {
            StreamUtils.close(aOS);
        }
    }
}

