/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.utils;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.AbstractMicroNode;
import com.phloc.commons.microdom.impl.MicroCDATA;
import com.phloc.commons.microdom.impl.MicroComment;
import com.phloc.commons.microdom.impl.MicroDocument;
import com.phloc.commons.microdom.impl.MicroDocumentType;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.microdom.impl.MicroEntityReference;
import com.phloc.commons.microdom.impl.MicroProcessingInstruction;
import com.phloc.commons.microdom.impl.MicroText;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

@Immutable
public final class MicroUtils {
    private static final String BR_TAG = "br";
    private static final MicroUtils s_aInstance = new MicroUtils();

    private MicroUtils() {
    }

    @Nullable
    public static List<IMicroNode> nl2br(@Nullable String sText) {
        int i;
        if (sText == null) {
            return null;
        }
        ArrayList<IMicroNode> ret = new ArrayList<IMicroNode>();
        int start = 0;
        while ((i = sText.indexOf(10, start)) >= 0) {
            if (start != i) {
                ret.add(new MicroText(sText.substring(start, i)));
            }
            ret.add(new MicroElement(BR_TAG));
            start = i + 1;
        }
        if (start < sText.length()) {
            ret.add(new MicroText(sText.substring(start)));
        }
        return ret;
    }

    @Nonnull
    public static IMicroNode append(@Nonnull IMicroNode aSrcNode, @Nullable Object aChild) {
        if (aSrcNode == null) {
            throw new NullPointerException("srcNode");
        }
        if (aChild != null) {
            if (aChild instanceof IMicroNode) {
                aSrcNode.appendChild((IMicroNode)aChild);
            } else if (aChild instanceof String) {
                aSrcNode.appendText((String)aChild);
            } else if (aChild instanceof Iterable) {
                for (Object aSubChild : (Iterable)aChild) {
                    MicroUtils.append(aSrcNode, aSubChild);
                }
            } else if (ArrayHelper.isArray(aChild)) {
                for (Object aSubChild : (Object[])aChild) {
                    MicroUtils.append(aSrcNode, aSubChild);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to an IMicroNode (type=" + aChild.getClass().getName() + ".");
            }
        }
        return aSrcNode;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static String getPath(@Nullable IMicroNode aNode, @Nonnull String sSep) {
        if (sSep == null) {
            throw new NullPointerException("separator");
        }
        StringBuilder aSB = new StringBuilder();
        for (IMicroNode aCurrentNode = aNode; aCurrentNode != null; aCurrentNode = aCurrentNode.getParent()) {
            if (aSB.length() > 0) {
                aSB.insert(0, sSep);
            }
            aSB.insert(0, aCurrentNode.getNodeName());
        }
        return aSB.toString();
    }

    @Nullable
    public static String getDocumentRootElementTagName(@Nullable IMicroDocument aDoc) {
        IMicroElement eRoot;
        if (aDoc != null && (eRoot = aDoc.getDocumentElement()) != null) {
            return eRoot.getTagName();
        }
        return null;
    }

    @Nonnull
    public static IMicroNode convertToMicroNode(@Nonnull Node aNode) {
        AbstractMicroNode ret;
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        short nNodeType = aNode.getNodeType();
        switch (nNodeType) {
            case 9: {
                ret = new MicroDocument();
                break;
            }
            case 10: {
                DocumentType aDT = (DocumentType)aNode;
                ret = new MicroDocumentType(aDT.getName(), aDT.getPublicId(), aDT.getSystemId());
                break;
            }
            case 1: {
                MicroElement aElement = new MicroElement(aNode.getNodeName());
                NamedNodeMap aAttrs = aNode.getAttributes();
                if (aAttrs != null) {
                    int nAttrCount = aAttrs.getLength();
                    for (int i = 0; i < nAttrCount; ++i) {
                        Attr aAttr = (Attr)aAttrs.item(i);
                        aElement.setAttribute(aAttr.getName(), aAttr.getValue());
                    }
                }
                ret = aElement;
                break;
            }
            case 4: {
                ret = new MicroCDATA(aNode.getNodeValue());
                break;
            }
            case 3: {
                ret = new MicroText(aNode.getNodeValue());
                break;
            }
            case 8: {
                ret = new MicroComment(aNode.getNodeValue());
                break;
            }
            case 5: {
                ret = new MicroEntityReference(aNode.getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction aPI = (ProcessingInstruction)aNode;
                ret = new MicroProcessingInstruction(aPI.getTarget(), aPI.getData());
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Unknown/unsupported node type: ATTRIBUTE_NODE");
            }
            case 6: {
                throw new IllegalArgumentException("Unknown/unsupported node type: ENTITY_NODE");
            }
            case 11: {
                throw new IllegalArgumentException("Unknown/unsupported node type: DOCUMENT_FRAGMENT_NODE");
            }
            case 12: {
                throw new IllegalArgumentException("Unknown/unsupported node type: NOTATION_NODE");
            }
            default: {
                throw new IllegalArgumentException("Unknown/unsupported node type: " + nNodeType);
            }
        }
        NodeList aChildren = aNode.getChildNodes();
        if (aChildren != null) {
            int nChildCount = aChildren.getLength();
            for (int i = 0; i < nChildCount; ++i) {
                Node aChildNode = aChildren.item(i);
                ret.appendChild(MicroUtils.convertToMicroNode(aChildNode));
            }
        }
        return ret;
    }

    @Nullable
    public static String getChildTextContent(@Nonnull IMicroElement eParentElement, @Nonnull String sChildElementName) {
        IMicroElement eChildElement = eParentElement.getFirstChildElement(sChildElementName);
        return eChildElement != null ? eChildElement.getTextContent() : null;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE getChildTextContentWithConversion(@Nonnull IMicroElement eParentElement, @Nonnull String sChildElementName, @Nonnull Class<DSTTYPE> aDstClass) {
        IMicroElement eChildElement = eParentElement.getFirstChildElement(sChildElementName);
        return eChildElement != null ? (DSTTYPE)eChildElement.getTextContentWithConversion(aDstClass) : null;
    }

    @Nullable
    public static String getChildTextContent(@Nonnull IMicroElement eParentElement, @Nonnull String sNamespaceURI, @Nonnull String sChildElementName) {
        IMicroElement eChildElement = eParentElement.getFirstChildElement(sNamespaceURI, sChildElementName);
        return eChildElement != null ? eChildElement.getTextContent() : null;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE getChildTextContentWithConversion(@Nonnull IMicroElement eParentElement, @Nonnull String sNamespaceURI, @Nonnull String sChildElementName, @Nonnull Class<DSTTYPE> aDstClass) {
        IMicroElement eChildElement = eParentElement.getFirstChildElement(sNamespaceURI, sChildElementName);
        return eChildElement != null ? (DSTTYPE)eChildElement.getTextContentWithConversion(aDstClass) : null;
    }
}

