/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.thirdparty;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.thirdparty.ILicense;
import com.phloc.commons.thirdparty.IThirdPartyModule;
import com.phloc.commons.version.Version;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ThirdPartyModule
implements IThirdPartyModule {
    public static final boolean DEFAULT_OPTIONAL = false;
    private final String m_sDisplayName;
    private final String m_sCopyrightOwner;
    private final ILicense m_aLicense;
    private final Version m_aVersion;
    private final String m_sWebSiteURL;
    private final boolean m_bOptional;

    public ThirdPartyModule(@Nonnull @Nonempty String sDisplayName, @Nonnull @Nonempty String sCopyrightOwner, @Nonnull ILicense aLicense) {
        this(sDisplayName, sCopyrightOwner, aLicense, false);
    }

    public ThirdPartyModule(@Nonnull @Nonempty String sDisplayName, @Nonnull @Nonempty String sCopyrightOwner, @Nonnull ILicense aLicense, boolean bOptional) {
        this(sDisplayName, sCopyrightOwner, aLicense, null, null, bOptional);
    }

    public ThirdPartyModule(@Nonnull @Nonempty String sDisplayName, @Nonnull @Nonempty String sCopyrightOwner, @Nonnull ILicense aLicense, @Nullable Version aVersion, @Nullable String sWebsiteURL) {
        this(sDisplayName, sCopyrightOwner, aLicense, aVersion, sWebsiteURL, false);
    }

    public ThirdPartyModule(@Nonnull @Nonempty String sDisplayName, @Nonnull @Nonempty String sCopyrightOwner, @Nonnull ILicense aLicense, @Nullable Version aVersion, @Nullable String sWebsiteURL, boolean bOptional) {
        if (StringHelper.hasNoText(sDisplayName)) {
            throw new IllegalArgumentException("displayName");
        }
        if (StringHelper.hasNoText(sCopyrightOwner)) {
            throw new IllegalArgumentException("copyrightOwner");
        }
        if (aLicense == null) {
            throw new NullPointerException("license");
        }
        this.m_sDisplayName = sDisplayName;
        this.m_sCopyrightOwner = sCopyrightOwner;
        this.m_aLicense = aLicense;
        this.m_aVersion = aVersion;
        this.m_sWebSiteURL = sWebsiteURL;
        this.m_bOptional = bOptional;
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Override
    @Nonnull
    public String getCopyrightOwner() {
        return this.m_sCopyrightOwner;
    }

    @Override
    @Nonnull
    public ILicense getLicense() {
        return this.m_aLicense;
    }

    @Override
    @Nullable
    public Version getVersion() {
        return this.m_aVersion;
    }

    @Override
    @Nullable
    public String getWebSiteURL() {
        return this.m_sWebSiteURL;
    }

    @Override
    public boolean isOptional() {
        return this.m_bOptional;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThirdPartyModule)) {
            return false;
        }
        ThirdPartyModule rhs = (ThirdPartyModule)o;
        return this.m_sDisplayName.equals(rhs.m_sDisplayName) && this.m_sCopyrightOwner.equals(rhs.m_sCopyrightOwner) && this.m_aLicense.equals(rhs.m_aLicense) && EqualsUtils.equals(this.m_aVersion, rhs.m_aVersion) && EqualsUtils.equals(this.m_sWebSiteURL, rhs.m_sWebSiteURL) && this.m_bOptional == rhs.m_bOptional;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sDisplayName).append(this.m_sCopyrightOwner).append(this.m_aLicense).append(this.m_aVersion).append(this.m_sWebSiteURL).append(this.m_bOptional).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("displayName", this.m_sDisplayName).append("copyrightOwner", this.m_sCopyrightOwner).append("license", this.m_aLicense).appendIfNotNull("version", this.m_aVersion).appendIfNotNull("website", this.m_sWebSiteURL).append("optional", this.m_bOptional).toString();
    }
}

