/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.withid;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import com.phloc.commons.tree.withid.ITreeItemWithIDFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>>
implements ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE> {
    private final ITreeItemWithIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> m_aFactory;
    private ITEMTYPE m_aParent;
    private final KEYTYPE m_aDataID;
    private VALUETYPE m_aData;
    private Map<KEYTYPE, ITEMTYPE> m_aChildMap = null;
    private List<ITEMTYPE> m_aChildList = null;

    public BasicTreeItemWithID(@Nonnull ITreeItemWithIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> aFactory) {
        this(aFactory, (null));
    }

    public BasicTreeItemWithID(@Nonnull ITreeItemWithIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> aFactory, @Nullable KEYTYPE aDataID) {
        if (aFactory == null) {
            throw new NullPointerException("factory");
        }
        this.m_aFactory = aFactory;
        this.m_aDataID = aDataID;
    }

    public BasicTreeItemWithID(@Nonnull ITEMTYPE aParent, @Nonnull KEYTYPE aDataID) {
        if (aParent == null) {
            throw new NullPointerException("parent");
        }
        if (!(aParent instanceof BasicTreeItemWithID)) {
            throw new IllegalArgumentException("Parent is no BasicTreeItemWithID");
        }
        if (aDataID == null) {
            throw new NullPointerException("dataID");
        }
        if (aParent.getFactory() == null) {
            throw new IllegalStateException("Parent item has no factory!");
        }
        this.m_aParent = aParent;
        this.m_aFactory = this.m_aParent.getFactory();
        this.m_aDataID = aDataID;
    }

    @Override
    @Nonnull
    public final ITreeItemWithIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> getFactory() {
        return this.m_aFactory;
    }

    @OverrideOnDemand
    protected boolean isValidDataID(KEYTYPE aDataID) {
        return true;
    }

    @OverrideOnDemand
    protected boolean isValidData(VALUETYPE aData) {
        return true;
    }

    @Override
    public final boolean isRootItem() {
        return this.m_aParent == null;
    }

    @Nonnull
    private ITEMTYPE _asT(@Nonnull BasicTreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE> aItem) {
        return (ITEMTYPE)((ITreeItemWithID)GenericReflection.uncheckedCast(aItem));
    }

    @Override
    @Nullable
    public final ITEMTYPE getParent() {
        return this.m_aParent;
    }

    @Override
    @Nullable
    public final KEYTYPE getID() {
        return this.m_aDataID;
    }

    @Override
    @Nullable
    public final VALUETYPE getData() {
        return this.m_aData;
    }

    @Override
    public final boolean hasChildren() {
        return this.m_aChildMap != null && !this.m_aChildMap.isEmpty();
    }

    @Override
    @Nonnegative
    public final int getChildCount() {
        return this.m_aChildMap == null ? 0 : this.m_aChildMap.size();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public final List<ITEMTYPE> getChildren() {
        return this.m_aChildList == null ? null : ContainerHelper.newList(this.m_aChildList);
    }

    @Override
    @Nullable
    public final ITEMTYPE getChildAtIndex(@Nonnegative int nIndex) {
        if (this.m_aChildList == null) {
            throw new IndexOutOfBoundsException("Tree item has no children!");
        }
        return (ITEMTYPE)((ITreeItemWithID)this.m_aChildList.get(nIndex));
    }

    @Override
    public final void setData(@Nullable VALUETYPE aData) {
        if (!this.isValidData(aData)) {
            throw new IllegalArgumentException("The passed data object is invalid!");
        }
        this.m_aData = aData;
    }

    @Override
    @Nullable
    public final ITEMTYPE createChildItem(@Nullable KEYTYPE aDataID, @Nullable VALUETYPE aData) {
        return this.createChildItem(aDataID, aData, true);
    }

    @Override
    @Nullable
    public final ITEMTYPE createChildItem(@Nullable KEYTYPE aDataID, @Nullable VALUETYPE aData, boolean bAllowOverwrite) {
        if (!this.isValidDataID(aDataID)) {
            throw new IllegalArgumentException("Illegal data ID provided");
        }
        ITEMTYPE aItem = this.getChildItemOfDataID(aDataID);
        if (aItem != null) {
            if (!bAllowOverwrite) {
                return null;
            }
            aItem.setData(aData);
        } else {
            aItem = this.m_aFactory.create(this._asT(this), aDataID);
            if (aItem == null) {
                throw new IllegalStateException("null item created!");
            }
            aItem.setData(aData);
            if (this.m_aChildMap == null) {
                this.m_aChildMap = new HashMap<KEYTYPE, ITEMTYPE>();
                this.m_aChildList = new ArrayList<ITEMTYPE>();
            }
            this.m_aChildMap.put(aDataID, aItem);
            this.m_aChildList.add(aItem);
        }
        return aItem;
    }

    @Override
    @Nullable
    public final ITEMTYPE getChildItemOfDataID(@Nullable KEYTYPE aDataID) {
        return (ITEMTYPE)(this.m_aChildMap == null ? null : (ITreeItemWithID)this.m_aChildMap.get(aDataID));
    }

    @Override
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public final boolean isSameOrChildOf(@Nonnull ITEMTYPE aParent) {
        if (aParent == null) {
            throw new NullPointerException("parent");
        }
        for (ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE> aCur = this; aCur != null; aCur = (ITreeItemWithID)aCur.getParent()) {
            if (aCur != aParent) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public final ESuccess changeParent(@Nonnull ITEMTYPE aNewParent) {
        if (aNewParent == null) {
            throw new NullPointerException("newParent");
        }
        if (this.getParent() == aNewParent) {
            return ESuccess.SUCCESS;
        }
        ITEMTYPE aThis = this._asT(this);
        if (aNewParent.isSameOrChildOf(aThis)) {
            return ESuccess.FAILURE;
        }
        if (this.m_aParent.removeChild(this.getID()).isUnchanged()) {
            throw new IllegalStateException("Failed to remove this from parent!");
        }
        this.m_aParent = aNewParent;
        return ESuccess.valueOfChange(aNewParent.internalAddChild(this.getID(), aThis, false));
    }

    @Override
    @Nonnull
    public final EChange internalAddChild(@Nonnull KEYTYPE aDataID, @Nonnull ITEMTYPE aChild, boolean bAllowOverwrite) {
        if (aChild == null) {
            throw new NullPointerException("child");
        }
        if (this.m_aChildMap != null) {
            if (!bAllowOverwrite && this.m_aChildMap.containsKey(aDataID)) {
                return EChange.UNCHANGED;
            }
        } else {
            this.m_aChildMap = new HashMap<KEYTYPE, ITEMTYPE>();
            this.m_aChildList = new ArrayList<ITEMTYPE>();
        }
        this.m_aChildMap.put(aDataID, aChild);
        this.m_aChildList.add(aChild);
        this.m_aFactory.onAddItem(aChild);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange removeChild(@Nonnull KEYTYPE aDataID) {
        if (aDataID == null) {
            throw new NullPointerException("dataID");
        }
        if (this.m_aChildMap == null) {
            return EChange.UNCHANGED;
        }
        ITreeItemWithID aItem = (ITreeItemWithID)this.m_aChildMap.remove(aDataID);
        if (aItem == null) {
            return EChange.UNCHANGED;
        }
        if (!this.m_aChildList.remove(aItem)) {
            throw new IllegalStateException("Failed to remove item from list: " + aItem);
        }
        this.m_aFactory.onRemoveItem(aItem);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange removeAllChildren() {
        if (this.m_aChildMap == null || this.m_aChildMap.isEmpty()) {
            return EChange.UNCHANGED;
        }
        ArrayList<ITEMTYPE> aAllChildren = new ArrayList<ITEMTYPE>(this.m_aChildList);
        this.m_aChildMap.clear();
        this.m_aChildList.clear();
        for (ITreeItemWithID aItem : aAllChildren) {
            this.m_aFactory.onRemoveItem(aItem);
        }
        return EChange.CHANGED;
    }

    @Override
    public final void reorderChildrenByItems(@Nonnull Comparator<? super ITEMTYPE> aComparator) {
        if (this.m_aChildList != null) {
            ContainerHelper.getSortedInline(this.m_aChildList, aComparator);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        BasicTreeItemWithID rhs = (BasicTreeItemWithID)o;
        return EqualsUtils.equals(this.m_aDataID, rhs.m_aDataID) && EqualsUtils.equals(this.m_aData, rhs.m_aData) && EqualsUtils.equals(this.m_aChildMap, rhs.m_aChildMap);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aData).append(this.m_aDataID).append((Map)this.m_aChildMap)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("dataID", this.m_aDataID).append("data", this.m_aData).append("children", this.m_aChildMap).toString();
    }
}

